/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities.ai;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.ai.ShieldCombatGoal;
import blusunrize.immersiveengineering.common.entities.illager.Commando;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RevolverAttackGoal<T extends Commando>
extends ShieldCombatGoal<T> {
    private int bulletCount = 0;
    private int maxBullets;

    public RevolverAttackGoal(T mob, float attackRadius, int maxBullets) {
        super(mob, attackRadius, new ShieldCombatGoal.IntRange(120, 180), new ShieldCombatGoal.IntRange(20, 40));
        this.maxBullets = maxBullets;
    }

    public void setMaxBullets(int maxBullets) {
        this.maxBullets = maxBullets;
    }

    @Override
    protected boolean isHoldingWeapon() {
        return ((Commando)this.mob).m_21093_(is -> is.m_41720_() instanceof RevolverItem);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.combatState == ShieldCombatGoal.ShieldCombatState.STRAFE && this.bulletCount > 0 && ((Commando)this.mob).f_19797_ % 20 == 0 && --this.bulletCount == 0) {
            ((Commando)this.mob).m_9236_().m_6263_(null, ((Commando)this.mob).m_20185_(), ((Commando)this.mob).m_20186_(), ((Commando)this.mob).m_20189_(), (SoundEvent)IESounds.revolverReload.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (this.combatState == ShieldCombatGoal.ShieldCombatState.ATTACK && !((Commando)this.mob).isAiming()) {
            ((Commando)this.mob).setAiming(true);
        }
        if (this.combatState != ShieldCombatGoal.ShieldCombatState.ATTACK && ((Commando)this.mob).isAiming()) {
            ((Commando)this.mob).setAiming(false);
        }
    }

    @Override
    boolean performAttack() {
        ItemStack revolver = ((Commando)this.mob).m_21120_(InteractionHand.MAIN_HAND);
        ItemStack bulletStack = ((Commando)this.mob).getRevolverAmmo();
        BulletHandler.IBullet bulletType = ((BulletItem)bulletStack.m_41720_()).getType();
        RevolverItem.fireProjectile(((Commando)this.mob).m_9236_(), (LivingEntity)this.mob, revolver, bulletType, bulletStack);
        ++this.bulletCount;
        return this.bulletCount >= this.maxBullets;
    }
}

