/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.EnumMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBatcherBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<ItemBatcherBlockEntity>,
IEBlockInterfaces.IStateBasedDirectional {
    public static final int NUM_SLOTS = 9;
    private final NonNullList<ItemStack> filters = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> buffers = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    public BatchMode batchMode = BatchMode.ALL;
    public NonNullList<DyeColor> redstoneColors = NonNullList.m_122780_((int)9, (Object)DyeColor.WHITE);
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.f_58858_.m_121945_(this.getFacing()), this.getFacing().m_122424_()), ForgeCapabilities.ITEM_HANDLER);
    private final ResettableCapability<IItemHandler> insertionCap = this.registerCapability(new IEInventoryHandler(9, (IIEInventory)this, 0, true, false));
    private final ResettableCapability<CapabilityRedstoneNetwork.RedstoneBundleConnection> redstoneCap = this.registerCapability(new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

        @Override
        public void updateInput(byte[] signals, Direction side) {
            Set<DyeColor> outputMap = ItemBatcherBlockEntity.this.calculateRedstoneOutputs();
            for (DyeColor dye : outputMap) {
                signals[dye.m_41060_()] = (byte)Math.max(signals[dye.m_41060_()], 15);
            }
        }
    });

    public ItemBatcherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.ITEM_BATCHER.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.m_6144_();
    }

    @Override
    public void tickServer() {
        if (this.f_58857_.m_46467_() % 8L != 0L || !this.isActive()) {
            return;
        }
        IItemHandler outputHandler = this.output.getNullable();
        if (outputHandler != null) {
            boolean matched = true;
            if (this.batchMode == BatchMode.ALL) {
                for (int slot = 0; slot < 9; ++slot) {
                    if (((ItemStack)this.filters.get(slot)).m_41619_()) continue;
                    matched &= this.isFilterMatched(slot);
                }
            }
            if (matched) {
                boolean anySent = false;
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack filterStack = (ItemStack)this.filters.get(slot);
                    if (filterStack.m_41619_() || this.batchMode != BatchMode.ALL && !this.isFilterMatched(slot)) continue;
                    ItemStack outStack = (ItemStack)this.buffers.get(slot);
                    int outSize = filterStack.m_41613_();
                    ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)outStack, (int)outSize);
                    if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) {
                        outSize -= stack.m_41613_();
                    }
                    outStack.m_41774_(outSize);
                    if (outStack.m_41613_() <= 0) {
                        this.buffers.set(slot, (Object)ItemStack.f_41583_);
                    }
                    anySent = true;
                }
                if (anySent) {
                    this.redstoneCap.get().markDirty();
                }
            }
        }
    }

    protected boolean isActive() {
        return !this.isRSPowered();
    }

    protected boolean isFilterMatched(int slot) {
        return ItemUtils.isSameIgnoreDurability((ItemStack)this.filters.get(slot), (ItemStack)this.buffers.get(slot)) && ((ItemStack)this.buffers.get(slot)).m_41613_() >= ((ItemStack)this.filters.get(slot)).m_41613_();
    }

    protected Set<DyeColor> calculateRedstoneOutputs() {
        EnumMap<DyeColor, Boolean> map = new EnumMap<DyeColor, Boolean>(DyeColor.class);
        for (int slot = 0; slot < 9; ++slot) {
            DyeColor dye;
            if (((ItemStack)this.filters.get(slot)).m_41619_()) continue;
            Boolean ex = (Boolean)map.get(dye = (DyeColor)this.redstoneColors.get(slot));
            map.put(dye, ex != null ? ex.booleanValue() && this.isFilterMatched(slot) : this.isFilterMatched(slot));
        }
        return map.keySet().stream().filter(map::get).collect(Collectors.toSet());
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int i;
        if (!descPacket) {
            NonNullList merged = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)merged);
            for (i = 0; i < 9; ++i) {
                this.buffers.set(i, (Object)((ItemStack)merged.get(i + 9)));
                this.filters.set(i, (Object)((ItemStack)merged.get(i)));
            }
        }
        this.batchMode = BatchMode.values()[nbt.m_128445_("batchMode")];
        int[] redstoneConfig = nbt.m_128465_("redstoneColors");
        if (redstoneConfig.length >= 9) {
            for (i = 0; i < 9; ++i) {
                this.redstoneColors.set(i, (Object)DyeColor.m_41053_((int)redstoneConfig[i]));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int i;
        if (!descPacket) {
            NonNullList merged = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
            for (i = 0; i < 9; ++i) {
                merged.set(i + 9, (Object)((ItemStack)this.buffers.get(i)));
                merged.set(i, (Object)((ItemStack)this.filters.get(i)));
            }
            ContainerHelper.m_18973_((CompoundTag)nbt, (NonNullList)merged);
        }
        nbt.m_128344_("batchMode", (byte)this.batchMode.ordinal());
        int[] redstoneConfig = new int[9];
        for (i = 0; i < 9; ++i) {
            redstoneConfig[i] = ((DyeColor)this.redstoneColors.get(i)).m_41060_();
        }
        nbt.m_128385_("redstoneColors", redstoneConfig);
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.m_128441_("batchMode")) {
            this.batchMode = BatchMode.values()[message.m_128445_("batchMode")];
        }
        if (message.m_128441_("redstoneColor_slot") && message.m_128441_("redstoneColor_val")) {
            this.redstoneColors.set(message.m_128451_("redstoneColor_slot"), (Object)DyeColor.m_41053_((int)message.m_128451_("redstoneColor_val")));
        }
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ItemBatcherBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<ItemBatcherBlockEntity, ?> getContainerType() {
        return IEMenuTypes.ITEM_BATCHER;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.buffers;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return ItemUtils.isSameIgnoreDurability((ItemStack)this.filters.get(slot), stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.redstoneCap.get().markDirty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing == this.getFacing().m_122424_()) {
            return this.insertionCap.cast();
        }
        if (capability == CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION) {
            return this.redstoneCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public NonNullList<ItemStack> getFilters() {
        return this.filters;
    }

    public static enum BatchMode {
        SINGLE,
        ALL;

    }
}

