/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.ItemEntityAccess;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ChuteBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds {
    private static final String NBT_POS = "immersiveengineering:chutePos";
    private static final String NBT_TIME = "immersiveengineering:chuteTime";
    private static final String NBT_GLITCH = "immersiveengineering:chuteGlitched";
    private static final String NBT_COUNT = "immersiveengineering:chuteCount";
    private boolean diagonal = false;
    static final Map<Direction, AABB> AABB_SIDES = new EnumMap<Direction, AABB>(Direction.class);
    static final AABB AABB_DOWN;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES;
    static final VoxelShape selectionShape;
    private final ResettableCapability<IItemHandler> insertionCap = this.registerCapability(new ChuteInventoryHandler(this));

    public ChuteBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CHUTE.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return !entity.m_6144_();
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        boolean contact = false;
        Direction facing = this.getFacing();
        if (!this.diagonal) {
            contact = entity.m_20186_() - (double)this.m_58899_().m_123342_() <= 0.125;
        } else if (facing == Direction.NORTH) {
            contact = entity.m_20189_() - (double)this.m_58899_().m_123343_() <= 0.125;
        } else if (facing == Direction.SOUTH) {
            contact = entity.m_20189_() - (double)this.m_58899_().m_123343_() >= 0.875;
        } else if (facing == Direction.WEST) {
            contact = entity.m_20185_() - (double)this.m_58899_().m_123341_() <= 0.125;
        } else if (facing == Direction.EAST) {
            boolean bl = contact = entity.m_20185_() - (double)this.m_58899_().m_123341_() >= 0.875;
        }
        if (this.diagonal && entity.m_20186_() - (double)this.m_58899_().m_123342_() <= 0.625) {
            boolean glitched;
            boolean opposedChute;
            BlockPos target = this.m_58899_().m_121945_(facing);
            BlockEntity targetTile = world.m_7702_(target);
            boolean bl = opposedChute = targetTile instanceof ChuteBlockEntity && ((ChuteBlockEntity)targetTile).diagonal;
            if (opposedChute) {
                return;
            }
            long time = world.m_46467_();
            long nbt_pos = this.m_58899_().m_121878_();
            long timeSince = time - entity.getPersistentData().m_128454_(NBT_TIME);
            boolean prevent = entity.getPersistentData().m_128441_(NBT_POS) && nbt_pos == entity.getPersistentData().m_128454_(NBT_POS) && timeSince < 20L;
            boolean bl2 = glitched = entity.getPersistentData().m_128441_(NBT_GLITCH) && time - entity.getPersistentData().m_128454_(NBT_GLITCH) < 1200L;
            if ((double)entity.m_20205_() > 0.75 || (double)entity.m_20206_() > 0.75) {
                if (world.m_8055_(target).m_60828_((BlockGetter)world, target)) {
                    return;
                }
                if (!glitched) {
                    Vec3 oldPos = entity.m_20182_();
                    double py = entity.m_20206_() > 1.0f ? (double)this.m_58899_().m_123342_() + 0.125 : entity.m_20186_();
                    entity.m_6034_((double)target.m_123341_() + 0.5, py, (double)target.m_123343_() + 0.5);
                    if (entity.m_5830_()) {
                        entity.m_6034_(oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_);
                        entity.getPersistentData().m_128356_(NBT_GLITCH, time);
                    }
                }
            } else {
                double mY = entity.m_20184_().f_82480_;
                if (mY == 0.0) {
                    mY = 0.015;
                }
                entity.m_20334_((double)facing.m_122429_(), mY, (double)facing.m_122431_());
            }
            if (!(contact || prevent || glitched)) {
                world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)IESounds.chute.get(), SoundSource.BLOCKS, 0.6f + 0.4f * world.f_46441_.m_188501_(), 0.5f + 0.5f * world.f_46441_.m_188501_());
                CompoundTag entityData = entity.getPersistentData();
                entityData.m_128356_(NBT_POS, nbt_pos);
                entityData.m_128356_(NBT_TIME, time);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!world.m_5776_()) {
                        int bonkCount = entityData.m_128451_(NBT_COUNT) + 1;
                        if (timeSince > 200L) {
                            bonkCount = 1;
                        }
                        entity.getPersistentData().m_128405_(NBT_COUNT, bonkCount);
                        if (bonkCount >= 6) {
                            Utils.unlockIEAdvancement(player, "main/chute_bonk");
                        }
                    }
                }
            }
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            itemEntity.m_32010_(10);
            if (!contact) {
                if (itemEntity.m_32059_() > itemEntity.lifespan - 1200) {
                    ((ItemEntityAccess)itemEntity).setAge(itemEntity.lifespan - 1200);
                }
            } else {
                Direction insertFrom;
                BlockPos invPos = this.diagonal ? this.m_58899_().m_121945_(facing) : this.m_58899_().m_7495_();
                BlockEntity inventoryTile = world.m_7702_(invPos);
                Direction direction = insertFrom = this.diagonal ? facing.m_122424_() : Direction.UP;
                if (!world.f_46443_ && this.isValidTargetInventory(inventoryTile)) {
                    ItemUtils.tryInsertEntity(world, invPos, insertFrom, itemEntity);
                }
            }
        }
    }

    private boolean isValidTargetInventory(@Nullable BlockEntity inventoryTile) {
        if (inventoryTile != null) {
            if (inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity) {
                ConveyorHandler.IConveyorBlockEntity conveyorTile = (ConveyorHandler.IConveyorBlockEntity)inventoryTile;
                return ChuteBlockEntity.isCovered(conveyorTile.getConveyorInstance());
            }
            return true;
        }
        return false;
    }

    private static <T extends IConveyorBelt> boolean isCovered(IConveyorBelt belt) {
        return IConveyorBelt.isCovered(belt, Blocks.f_50016_);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.diagonal = nbt.m_128471_("diagonal");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128379_("diagonal", this.diagonal);
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(this));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        return selectionShape;
    }

    public boolean isInwardConveyor(Direction f) {
        Object sub;
        ConveyorHandler.IConveyorBlockEntity conveyorBE;
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_121945_(f));
        if (te instanceof ConveyorHandler.IConveyorBlockEntity) {
            conveyorBE = (ConveyorHandler.IConveyorBlockEntity)te;
            Object sub2 = conveyorBE.getConveyorInstance();
            if (sub2 != null) {
                boolean isInputting = false;
                Direction[] directionArray = sub2.sigTransportDirections();
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    Direction f2 = directionArray[i];
                    if (f == f2.m_122424_()) {
                        isInputting = true;
                        continue;
                    }
                    if (f2 != Direction.UP) continue;
                    isInputting = false;
                    break;
                }
                if (isInputting) {
                    return true;
                }
            }
        } else if (te instanceof ChuteBlockEntity) {
            ChuteBlockEntity chute = (ChuteBlockEntity)te;
            return chute.diagonal && chute.getFacing() == f.m_122424_();
        }
        if ((te = this.f_58857_.m_7702_(this.m_58899_().m_7918_(0, -1, 0).m_121945_(f))) instanceof ConveyorHandler.IConveyorBlockEntity && (sub = (conveyorBE = (ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance()) != null) {
            int b = 0;
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f == f2.m_122424_()) {
                    ++b;
                } else if (Direction.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (player.m_6144_()) {
            if (!this.f_58857_.f_46443_) {
                this.diagonal = !this.diagonal;
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
                this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public boolean isDiagonal() {
        return this.diagonal;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == Direction.UP) {
            return this.insertionCap.cast();
        }
        return super.getCapability(cap, side);
    }

    static {
        AABB_SIDES.put(Direction.NORTH, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
        AABB_SIDES.put(Direction.SOUTH, new AABB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
        AABB_SIDES.put(Direction.WEST, new AABB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
        AABB_SIDES.put(Direction.EAST, new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
        AABB_DOWN = new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        SHAPES = new CachedVoxelShapes<BoundingBoxKey>(BoundingBoxKey::getBoxes);
        selectionShape = Shapes.m_83144_();
    }

    public static class ChuteInventoryHandler
    implements IItemHandler {
        ChuteBlockEntity chute;

        public ChuteInventoryHandler(ChuteBlockEntity chute) {
            this.chute = chute;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                ItemEntity entity = new ItemEntity(this.chute.getLevelNonnull(), (double)this.chute.m_58899_().m_123341_() + 0.5, (double)this.chute.m_58899_().m_123342_() + 0.5, (double)this.chute.m_58899_().m_123343_() + 0.5, stack.m_41777_());
                entity.m_20256_(Vec3.f_82478_);
                this.chute.getLevelNonnull().m_7967_((Entity)entity);
                entity.m_32010_(10);
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }

    private static class BoundingBoxKey {
        private final boolean diagonal;
        private final Set<Direction> sidesToAdd;

        private BoundingBoxKey(ChuteBlockEntity te) {
            this.diagonal = te.diagonal;
            this.sidesToAdd = EnumSet.noneOf(Direction.class);
            for (Direction dir : DirectionUtils.BY_HORIZONTAL_INDEX) {
                if (te.isInwardConveyor(dir) || this.diagonal && dir == te.getFacing()) continue;
                this.sidesToAdd.add(dir);
            }
        }

        private List<AABB> getBoxes() {
            ArrayList<AABB> list = new ArrayList<AABB>();
            for (Direction d : this.sidesToAdd) {
                list.add(AABB_SIDES.get(d));
            }
            for (Direction sideA : DirectionUtils.BY_HORIZONTAL_INDEX) {
                Direction sideB = sideA.m_122427_();
                if (this.sidesToAdd.contains(sideA) || this.sidesToAdd.contains(sideB)) continue;
                AABB boxA = AABB_SIDES.get(sideA);
                AABB boxB = AABB_SIDES.get(sideB);
                list.add(boxA.m_82323_(boxB));
            }
            if (this.diagonal) {
                list.add(AABB_DOWN);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.diagonal == that.diagonal && this.sidesToAdd.equals(that.sidesToAdd);
        }

        public int hashCode() {
            return Objects.hash(this.diagonal, this.sidesToAdd);
        }
    }
}

