/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class SafeChunkUtils {
    private static final Map<LevelAccessor, Set<ChunkPos>> unloadingChunks = new WeakHashMap<LevelAccessor, Set<ChunkPos>>();

    public static LevelChunk getSafeChunk(LevelAccessor w, BlockPos pos) {
        ChunkSource provider = w.m_7726_();
        ChunkPos chunkPos = new ChunkPos(pos);
        if (unloadingChunks.getOrDefault(w, (Set<ChunkPos>)ImmutableSet.of()).contains(chunkPos)) {
            return null;
        }
        return provider.m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public static boolean isChunkSafe(LevelAccessor w, BlockPos pos) {
        return SafeChunkUtils.getSafeChunk(w, pos) != null;
    }

    public static BlockEntity getSafeBE(LevelAccessor w, BlockPos pos) {
        LevelChunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return null;
        }
        return c.m_7702_(pos);
    }

    @Nonnull
    public static BlockState getBlockState(LevelAccessor w, BlockPos pos) {
        LevelChunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return c.m_8055_(pos);
    }

    public static int getRedstonePower(Level w, BlockPos pos, Direction d) {
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)w, pos)) {
            return 0;
        }
        return w.m_277185_(pos, d);
    }

    public static int getRedstonePowerFromNeighbors(Level w, BlockPos pos) {
        Direction d;
        int atNeighbor;
        int ret = 0;
        Direction[] directionArray = DirectionUtils.VALUES;
        int n = directionArray.length;
        for (int i = 0; i < n && (ret = Math.max(ret, atNeighbor = SafeChunkUtils.getRedstonePower(w, pos.m_121945_(d = directionArray[i]), d))) < 15; ++i) {
        }
        return ret;
    }

    public static void onChunkUnload(ChunkEvent.Unload ev) {
        unloadingChunks.computeIfAbsent(ev.getLevel(), w -> new HashSet()).add(ev.getChunk().m_7697_());
    }

    public static void onTick(TickEvent.LevelTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            unloadingChunks.remove(ev.level);
        }
    }
}

