/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlueprintCraftingRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<BlueprintCraftingRecipe>> SERIALIZER;
    public static final CachedRecipeList<BlueprintCraftingRecipe> RECIPES;
    private static int reloadCountForCategories;
    private static Map<String, List<BlueprintCraftingRecipe>> recipesByCategory;
    public static SetRestrictedField<ItemLike> blueprintItem;
    public final String blueprintCategory;
    public final Lazy<ItemStack> output;
    public final IngredientWithSize[] inputs;

    public BlueprintCraftingRecipe(ResourceLocation id, String blueprintCategory, Lazy<ItemStack> output, IngredientWithSize[] inputs) {
        super(output, IERecipeTypes.BLUEPRINT, id);
        this.blueprintCategory = blueprintCategory;
        this.output = output;
        this.inputs = inputs;
        this.setInputListWithSizes(Lists.newArrayList((Object[])this.inputs));
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.output.get()}));
        this.setTimeAndEnergy(180, 23040);
    }

    protected IERecipeSerializer<BlueprintCraftingRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static ItemStack getTypedBlueprint(String type) {
        ItemStack stack = new ItemStack(blueprintItem.getValue());
        stack.m_41784_().m_128359_("blueprint", type);
        return stack;
    }

    public boolean matchesRecipe(NonNullList<ItemStack> query) {
        return this.getMaxCrafted(query) > 0;
    }

    public int getMaxCrafted(NonNullList<ItemStack> query) {
        HashMap<ItemStack, Integer> queryAmount = new HashMap<ItemStack, Integer>();
        for (ItemStack q : query) {
            if (q.m_41619_()) continue;
            boolean inc = false;
            for (ItemStack key : queryAmount.keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)q, (ItemStack)key)) continue;
                queryAmount.put(key, (Integer)queryAmount.get(key) + q.m_41613_());
                inc = true;
            }
            if (inc) continue;
            queryAmount.put(q, q.m_41613_());
        }
        OptionalInt maxCrafted = OptionalInt.empty();
        for (IngredientWithSize ingr : this.inputs) {
            int maxCraftedWithIngredient = 0;
            int req = ingr.getCount();
            Iterator queryIt = queryAmount.entrySet().iterator();
            while (queryIt.hasNext()) {
                int taken;
                Map.Entry e = queryIt.next();
                ItemStack compStack = (ItemStack)e.getKey();
                if (!ingr.testIgnoringSize(compStack) || (taken = (Integer)e.getValue() / req) <= 0) continue;
                e.setValue((Integer)e.getValue() - taken * req);
                if ((Integer)e.getValue() <= 0) {
                    queryIt.remove();
                }
                maxCraftedWithIngredient += taken;
            }
            if (maxCraftedWithIngredient <= 0) {
                return 0;
            }
            maxCrafted = maxCrafted.isPresent() ? OptionalInt.of(Math.min(maxCrafted.getAsInt(), maxCraftedWithIngredient)) : OptionalInt.of(maxCraftedWithIngredient);
        }
        return maxCrafted.orElse(0);
    }

    public NonNullList<ItemStack> consumeInputs(NonNullList<ItemStack> query, int crafted) {
        ArrayList<IngredientWithSize> inputList = new ArrayList<IngredientWithSize>(this.inputs.length);
        for (IngredientWithSize i : this.inputs) {
            if (i == null) continue;
            inputList.add(i);
        }
        NonNullList consumed = NonNullList.m_122779_();
        Iterator inputIt = inputList.iterator();
        block1: while (inputIt.hasNext()) {
            IngredientWithSize ingr = (IngredientWithSize)inputIt.next();
            int inputSize = ingr.getCount() * crafted;
            for (int i = 0; i < query.size(); ++i) {
                ItemStack queryStack = (ItemStack)query.get(i);
                if (queryStack.m_41619_() || !ingr.testIgnoringSize(queryStack)) continue;
                int taken = Math.min(queryStack.m_41613_(), inputSize);
                consumed.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)queryStack, (int)taken));
                if (taken >= queryStack.m_41613_() && queryStack.m_41720_().hasCraftingRemainingItem(queryStack)) {
                    query.set(i, (Object)queryStack.m_41720_().getCraftingRemainingItem(queryStack));
                } else {
                    queryStack.m_41774_(taken);
                }
                if ((inputSize -= taken) > 0) continue;
                inputIt.remove();
                continue block1;
            }
        }
        return consumed;
    }

    public static BlueprintCraftingRecipe[] findRecipes(Level level, String blueprintCategory) {
        BlueprintCraftingRecipe.updateRecipeCategories(level);
        return recipesByCategory.getOrDefault(blueprintCategory, (List<BlueprintCraftingRecipe>)ImmutableList.of()).toArray(new BlueprintCraftingRecipe[0]);
    }

    public static void updateRecipeCategories(Level level) {
        if (reloadCountForCategories == CachedRecipeList.getReloadCount()) {
            return;
        }
        recipesByCategory = RECIPES.getRecipes(level).stream().collect(Collectors.groupingBy(r -> r.blueprintCategory));
        for (Map.Entry<String, List<BlueprintCraftingRecipe>> e : recipesByCategory.entrySet()) {
            e.getValue().sort(Comparator.comparing(IESerializableRecipe::m_6423_));
        }
        reloadCountForCategories = CachedRecipeList.getReloadCount();
    }

    public static Set<String> getCategoriesWithRecipes(Level level) {
        BlueprintCraftingRecipe.updateRecipeCategories(level);
        return recipesByCategory.keySet();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList<BlueprintCraftingRecipe>(IERecipeTypes.BLUEPRINT);
        reloadCountForCategories = -1;
        recipesByCategory = Collections.emptyMap();
        blueprintItem = SetRestrictedField.common();
    }
}

