/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.datagen.blockstate;

import com.tynoxs.buildersdelight.content.block.custom.BlockInteractive;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BdBlockStateCreator
extends BlockStateProvider {
    public BdBlockStateCreator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "buildersdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    @NotNull
    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    public void lampBlock(RedstoneLampBlock block, ResourceLocation textureLampOff, ResourceLocation textureLampOn) {
        ModelBuilder lampOff = this.models().cubeAll(this.name((Block)block), textureLampOff);
        ModelBuilder lampOn = this.models().cubeAll(this.name((Block)block) + "_lit", ResourceLocation.m_135820_((String)(textureLampOn + "_lit")));
        this.lampBlock(block, (ModelFile)lampOff, (ModelFile)lampOn);
    }

    public void lampBlock(RedstoneLampBlock block, ModelFile modelLampOff, ModelFile modelLampOn) {
        this.getVariantBuilder((Block)block).partialState().with((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(modelLampOn)}).partialState().with((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(modelLampOff)});
    }

    public void interactiveBlock(BlockInteractive block, ResourceLocation textureOff, ResourceLocation textureOn) {
        ModelBuilder blockOff = this.models().cubeAll(this.name(block), textureOff);
        ModelBuilder blockOn = this.models().cubeAll(this.name(block) + "_on", ResourceLocation.m_135820_((String)(textureOn + "_on")));
        this.interactiveBlock(block, (ModelFile)blockOff, (ModelFile)blockOn);
    }

    public void interactiveBlock(BlockInteractive block, ModelFile modelBlockOff, ModelFile modelBlockOn) {
        this.getVariantBuilder(block).partialState().with(BlockInteractive.STATE, (Comparable)((Object)BlockInteractive.BlockInteractiveState.ON)).addModels(new ConfiguredModel[]{new ConfiguredModel(modelBlockOn)}).partialState().with(BlockInteractive.STATE, (Comparable)((Object)BlockInteractive.BlockInteractiveState.OFF)).addModels(new ConfiguredModel[]{new ConfiguredModel(modelBlockOff)});
    }

    public void simpleGlassBlock(Block block) {
        this.simpleGlassBlock(block, this.glassCubeAll(block));
    }

    public void simpleGlassBlock(Block block, ModelFile model) {
        this.simpleGlassBlock(block, new ConfiguredModel(model));
    }

    public void simpleGlassBlock(Block block, ConfiguredModel ... models) {
        this.getVariantBuilder(block).partialState().setModels(models);
    }

    public ModelFile glassCubeAll(Block block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block))).renderType("cutout");
    }

    public void topSideBlock(Block block, ResourceLocation side, ResourceLocation top) {
        this.horizontalBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeTop(this.name(block), side, ResourceLocation.m_135820_((String)(top + "_top")))).renderType("cutout"));
    }

    public void bdPaneBlock(IronBarsBlock block, ResourceLocation pane, ResourceLocation edge, String renderType) {
        this.bdPaneBlockInternal(block, this.key((Block)block).toString(), pane, ResourceLocation.m_135820_((String)(edge + "_top")), ResourceLocation.m_135820_((String)renderType));
    }

    private void bdPaneBlockInternal(IronBarsBlock block, String baseName, ResourceLocation pane, ResourceLocation edge, ResourceLocation renderType) {
        ModelBuilder post = ((BlockModelBuilder)this.models().panePost(baseName + "_post", pane, edge)).renderType(renderType);
        ModelBuilder side = ((BlockModelBuilder)this.models().paneSide(baseName + "_side", pane, edge)).renderType(renderType);
        ModelBuilder sideAlt = ((BlockModelBuilder)this.models().paneSideAlt(baseName + "_side_alt", pane, edge)).renderType(renderType);
        ModelBuilder noSide = ((BlockModelBuilder)this.models().paneNoSide(baseName + "_noside", pane)).renderType(renderType);
        ModelBuilder noSideAlt = ((BlockModelBuilder)this.models().paneNoSideAlt(baseName + "_noside_alt", pane)).renderType(renderType);
        this.paneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
    }
}

