/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.content.block.custom;

import com.tynoxs.buildersdelight.content.block.custom.WeatheringUtils;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface IWeatheringBlock
extends WeatheringCopper {
    public static Optional<BlockState> getWaxed(BlockState state) {
        WeatheringUtils.buildWaxBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.WAX_ON_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getUnwaxed(BlockState state) {
        WeatheringUtils.buildWaxBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.WAX_OFF_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    @NotNull
    default public Optional<BlockState> m_142123_(BlockState state) {
        return IWeatheringBlock.getNext(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getNext(Block block) {
        WeatheringUtils.buildBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.NEXT_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<Block> getPrevious(Block block) {
        WeatheringUtils.buildBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.PREVIOUS_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return IWeatheringBlock.getPrevious(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public InteractionResult applyWax(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HoneycombItem) {
            return IWeatheringBlock.getWaxed(state).map(waxedBlockState -> {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, itemstack);
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                level.m_7731_(pos, waxedBlockState, 11);
                level.m_5898_(player, 3003, pos, 0);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }
}

