/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.modules.selection;

import de.articdive.jnoise.core.api.modules.NoiseModule;
import de.articdive.jnoise.core.api.pipeline.NoiseSource;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import org.jetbrains.annotations.NotNull;

public final class SelectionModule
implements NoiseModule {
    private final NoiseSource a;
    private final NoiseSource b;
    private final NoiseSource controlSource;
    private final double boundary;

    private SelectionModule(@NotNull NoiseSource a, @NotNull NoiseSource b, @NotNull NoiseSource controlSource, double boundary) {
        this.a = a;
        this.b = b;
        this.controlSource = controlSource;
        this.boundary = boundary;
    }

    @Override
    public double evaluateNoise(double x) {
        if (this.controlSource.evaluateNoise(x) >= this.boundary) {
            return this.a.evaluateNoise(x);
        }
        return this.b.evaluateNoise(x);
    }

    @Override
    public double evaluateNoise(double x, double y) {
        if (this.controlSource.evaluateNoise(x, y) >= this.boundary) {
            return this.a.evaluateNoise(x, y);
        }
        return this.b.evaluateNoise(x, y);
    }

    @Override
    public double evaluateNoise(double x, double y, double z) {
        if (this.controlSource.evaluateNoise(x, y, z) >= this.boundary) {
            return this.a.evaluateNoise(x, y, z);
        }
        return this.b.evaluateNoise(x, y, z);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w) {
        if (this.controlSource.evaluateNoise(x, y, z, w) >= this.boundary) {
            return this.a.evaluateNoise(x, y, z, w);
        }
        return this.b.evaluateNoise(x, y, z, w);
    }

    @NotNull
    public static SelectionModuleBuilder newBuilder() {
        return new SelectionModuleBuilder();
    }

    public static final class SelectionModuleBuilder
    implements NoiseSourceBuilder {
        private NoiseSource a;
        private NoiseSource b;
        private NoiseSource controlSource;
        private double boundary = 0.0;

        private SelectionModuleBuilder() {
        }

        @NotNull
        public SelectionModuleBuilder setA(NoiseSource noiseSource) {
            if (noiseSource == null) {
                throw new IllegalArgumentException("First noise source cannot be null.");
            }
            this.a = noiseSource;
            return this;
        }

        @NotNull
        public SelectionModuleBuilder setA(NoiseSourceBuilder noiseSourceBuilder) {
            if (noiseSourceBuilder == null) {
                throw new IllegalArgumentException("First noise source cannot be null.");
            }
            this.a = noiseSourceBuilder.build();
            return this;
        }

        @NotNull
        public SelectionModuleBuilder setB(NoiseSource noiseSource) {
            if (noiseSource == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            this.b = noiseSource;
            return this;
        }

        @NotNull
        public SelectionModuleBuilder setB(NoiseSourceBuilder noiseSourceBuilder) {
            if (noiseSourceBuilder == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            this.b = noiseSourceBuilder.build();
            return this;
        }

        @NotNull
        public SelectionModuleBuilder setControl(NoiseSource noiseSource) {
            if (noiseSource == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            this.controlSource = noiseSource;
            return this;
        }

        @NotNull
        public SelectionModuleBuilder setControl(NoiseSourceBuilder noiseSourceBuilder) {
            if (noiseSourceBuilder == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            this.controlSource = noiseSourceBuilder.build();
            return this;
        }

        @NotNull
        public SelectionModuleBuilder setBoundary(double boundary) {
            this.boundary = boundary;
            return this;
        }

        @Override
        @NotNull
        public SelectionModule build() {
            if (this.a == null) {
                throw new IllegalArgumentException("First noise source cannot be null.");
            }
            if (this.b == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            if (this.controlSource == null) {
                throw new IllegalArgumentException("Control noise source cannot be null.");
            }
            return new SelectionModule(this.a, this.b, this.controlSource, this.boundary);
        }
    }
}

