/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.script_brush;

import java.util.Map;
import net.minecraft.class_2487;

public class ScriptBrushPresets {
    private static final String CLEAR = "local block = getBlock(x, y, z)\n\n-- Ignore air and water blocks\nif block == blocks.air or block == blocks.water then\n\treturn nil\nend\n\n-- Calculate replacement block (air or water)\nlocal replaceWith = getFluidBlockStateOrAir(block)\n\n-- Remove all non-solid blocks\nif not isSolid(block) then\n\treturn replaceWith\nend\n\n-- Remove all logs\nif isBlockTagged(block, \"logs\") then\n\treturn replaceWith\nend\n\n-- Remove all leaves\nif isBlockTagged(block, \"leaves\") then\n\treturn replaceWith\nend\n";
    private static final String TERRAIN_PLAINS = "-- Ignore non-solid blocks\nif not isSolid(getBlockState(x, y, z)) then\n    return nil\nend\n\n-- Load custom arguments\nlocal top = $blockState(Top, grass_block)$\nlocal mid = $blockState(Middle, dirt)$\nlocal below = $blockState(Bottom, stone)$\n\n-- Calculate depth\nlocal depth = 0\nfor i=0,6 do\n   if i == 6 then\n      return below\n   end\n   if not isSolid(getBlockState(x, y+i+1, z)) then\n       depth = i\n       break\n   end\nend\n\n-- Grass on top\nif depth == 0 then\n    return top\nend\n\n-- Dirt underneath\nlocal noise = getSimplexNoise(x/32, y/32, z/32)\nlocal dirt_depth\nif noise < 0.1 then\n    dirt_depth = 2\nelseif noise < 0.5 then\n    dirt_depth = 3\nelseif noise < 0.9 then\n    dirt_depth = 4\nelse\n    dirt_depth = 5\nend\n\nif depth < dirt_depth then\n    return mid\nelse\n    return below\nend\n";
    private static final String TERRAIN_DESERT = "-- Ignore non-solid blocks\nif not isSolid(getBlockState(x, y, z)) then\n    return nil\nend\n\n-- Load custom arguments\nlocal top = $blockState(Top, sand)$\nlocal below = $blockState(Bottom, sandstone)$\n\n-- Should always use the bottom block\n-- if below isn't solid\nif not isSolid(getBlockState(x, y-1, z)) then\n    return below\nend\n\n-- Calculate depth\nlocal depth = 0\nfor i=0,6 do\n   if i == 6 then\n      return below\n   end\n   if not isSolid(getBlockState(x, y+i+1, z)) then\n       depth = i\n       break\n   end\nend\n\n-- Calculate sand height based on noise\nlocal noise = getSimplexNoise(x/32, y/32, z/32)\nlocal below_depth\nif noise < 0.1 then\n    below_depth = 3\nelseif noise < 0.5 then\n    below_depth = 4\nelseif noise < 0.9 then\n    below_depth = 5\nelse\n    below_depth = 6\nend\n\n-- Set block based on depth\nif depth < below_depth then\n    return top\nelse\n    return below\nend\n";
    private static final String GRASS = "-- Check if target block is air\nif getBlock(x, y, z) ~= blocks.air then\n    return nil\nend\n\n-- Check if a solid block is below\nif not isSolid(getBlockState(x, y-1, z)) then\n    return nil\nend\n\n-- Load custom arguments\nlocal grassiness = $float(Grassiness, 0.5, 0.0, 1.0)$\nlocal do_tall_grass = $boolean(Allow Tall Grass, true)$\nlocal tall_grass = $blockState(Tall, tall_grass)$\nlocal short_grass = $blockState(Short, short_grass)$\n\n-- Base condition for grassiness\nif math.random() > grassiness then\n    return nil\nend\n\n-- Calculate noise values\nlocal simplex = getSimplexNoise(x/12, y/12, z/12)\nlocal white = math.random()\nlocal transformed\nif white < 0.5 then\n    transformed = math.sqrt(white / 2)\nelse\n    transformed = 1 - math.sqrt((1 - white)/2)\nend\n\n-- Update blocks based on noise\nif do_tall_grass and simplex < transformed/2 and math.random() < 0.35 then\n    local tall_grass_upper = withBlockProperty(tall_grass, \"half=upper\")\n    setBlock(x, y+1, z, tall_grass_upper)\n    return tall_grass\nelseif simplex < transformed then\n    return short_grass\nend\n";
    private static final String KELP = "-- Check if target block is water\nif getBlock(x, y, z) ~= blocks.water then\n\treturn nil\nend\n\n-- Check if there is a solid block below\nif not isSolid(getBlock(x, y-1, z)) then\n\treturn nil\nend\n\n-- Load custom arguments\nlocal amount = $float(Amount, 0.5, 0.0, 1.0)$\nlocal max_height = $int(Max Height, 10, 1, 19)$\n\n-- Control amount of kelp generated\nif math.random() > amount then\n\treturn\nend\n\n-- Kelp generation algorithm\nlocal height = math.random(max_height) - 1\nfor i=0,height do\n\tif getBlock(x, y+i, z) == blocks.water and getBlock(x, y+i+1, z) == blocks.water then\n\t\tif i == height then\n\t\t\tsetBlock(x, y+i, z, blocks.kelp)\n\t\telse\n\t\t\tsetBlock(x, y+i, z, blocks.kelp_plant)\n\t\tend\n\telseif i > 0 then\n\t\tsetBlock(x, y+i-1, z, blocks.kelp)\n\t\treturn\n    else\n        return\n\tend\nend\n";
    private static final String HEART = "$once$\n\nlocal size = 32\n\nfor xo=-size,size do\n\tfor yo=-size,size do\n\t\tfor zo=-size,size do\n\t\t\tlocal xr = xo/(0.8*size)\n\t\t\tlocal yr = yo/(0.8*size)\n\t\t\tlocal zr = zo/(0.8*size)\n\t\t\tlocal a = zr^2 + 9/4*(xr^2) + yr^2 - 1\n\t\t\tlocal b = -(zr^2) * (yr^3) - 9/80*(xr^2)*(yr^3)\n\t\t\tif a^3 + b < 0 then\n\t\t\t\tsetBlock(x+xo, y+yo+size, z+zo, blocks.red_wool)\n\t\t\tend\n\t\tend\n\tend\nend\n";
    private static final String LEAFY_BUSHES = "$once$\n\ny = y+1\n\n-- Check if target block is air\nif getBlock(x, y, z) ~= blocks.air then\n\treturn nil\nend\n\n-- Check if there is a solid block below\nif not isSolid(getBlock(x, y-1, z)) then\n\treturn nil\nend\n\n-- Load custom arguments\nlocal scale = $int(Scale, 4, 1, 8)$\nlocal block = $blockState(Block, oak_leaves)$\n\nfunction grow(x1, y1, z1, d, check_below)\n    -- Calculate growth chance\n\tlocal dx = x1 - x\n\tlocal dy = y1 - y\n\tlocal dz = z1 - z\n\tlocal distance = math.sqrt(dx^2 + dy^2 + dz^2)\n\tlocal factor = 3 * (1 - distance/scale)\n    local growth_chance = factor * d/scale\n\n    -- Check growth chance\n\tif math.random() > growth_chance then\n\t\treturn\n\tend\n\n\t-- Ensure replacing air\n\tif getBlock(x1, y1, z1) ~= blocks.air then\n\t\treturn\n\tend\n\n\t-- Ensure solid block is below, allowed to move down once\n\tif check_below >= 0 and not isSolid(getBlock(x1, y1-1, z1)) then\n\t\tif check_below > 0 then\n\t\t\treturn grow(x1, y1-1, z1, d, check_below - 1)\n\t\telse\n\t\t\treturn\n\t\tend\n\tend\n\n\t-- Set block to leaves\n\tsetBlock(x1, y1, z1, block)\n\n\t-- Propagate growth\n\tif d > 0 then\n\t\tgrow(x1+1, y1, z1, d-1, 1)\n\t\tgrow(x1-1, y1, z1, d-1, 1)\n\t\tgrow(x1, y1, z1+1, d-1, 1)\n\t\tgrow(x1, y1, z1-1, d-1, 1)\n\t\tgrow(x1, y1+1, z1, d-1.5, -1)\n\tend\nend\n\ngrow(x, y, z, scale, -1)\n";
    private static final String FLOWERS = "$once$\n\n-- Load custom arguments\nlocal tries = $int(Tries, 64, 0, 256)$\nlocal xzSpread = $int(XZ Spread, 6, 1, 32)$\nlocal ySpread = $int(Y Spread, 2, 1, 16)$\nlocal block = $blockState(Block, poppy)$\n\n-- Randomly place flowers\nfor i=0,tries do\n\t-- Calculate offset\n\tlocal xo = math.random(0, xzSpread) - math.random(0, xzSpread)\n\tlocal yo = math.random(0, ySpread) - math.random(0, ySpread)\n\tlocal zo = math.random(0, xzSpread) - math.random(0, xzSpread)\n\n\tif getBlockProperty(block, \"half\") ~= nil then\n\t\t-- Logic for double-tall blocks, eg. rose_bush\n\t\tif getBlock(x+xo, y+yo+1, z+zo) == blocks.air and\n\t\t\t\tgetBlock(x+xo, y+yo+2, z+zo) == blocks.air then\n\t\t\tif isSolid(getBlock(x+xo, y+yo, z+zo)) then\n\t\t\t\tsetBlock(x+xo, y+yo+1, z+zo,\n\t\t\t\t\t\twithBlockProperty(block, \"half=lower\"))\n\t\t\t\tsetBlock(x+xo, y+yo+2, z+zo,\n\t\t\t\t\t\twithBlockProperty(block, \"half=upper\"))\n\t\t\tend\n\t\tend\n\telse\n\t\t-- Logic for single-tall blocks, eg. poppy\n\t\tif getBlock(x+xo, y+yo+1, z+zo) == blocks.air then\n\t\t\tif isSolid(getBlock(x+xo, y+yo, z+zo)) then\n\t\t\t\tsetBlock(x+xo, y+yo+1, z+zo, block)\n\t\t\tend\n\t\tend\n\tend\nend\n";
    private static final String VINES = "if getBlock(x, y, z) ~= blocks.air then\n\treturn\nend\n\nlocal vine = blocks.vine\n\nif isSolid(getBlock(x, y, z-1)) then\n\tvine = withBlockProperty(vine, \"north=true\")\nend\nif isSolid(getBlock(x, y, z+1)) then\n\tvine = withBlockProperty(vine, \"south=true\")\nend\nif isSolid(getBlock(x+1, y, z)) then\n\tvine = withBlockProperty(vine, \"east=true\")\nend\nif isSolid(getBlock(x-1, y, z)) then\n\tvine = withBlockProperty(vine, \"west=true\")\nend\nif isSolid(getBlock(x, y+1, z)) then\n\tvine = withBlockProperty(vine, \"up=true\")\nend\n\nif vine ~= blocks.vine then\n\treturn vine\nend\n";

    public static Map<String, class_2487> getDefaultPresets() {
        return Map.ofEntries(Map.entry("Terrain: Plains", ScriptBrushPresets.createScriptTag(TERRAIN_PLAINS)), Map.entry("Terrain: Desert", ScriptBrushPresets.createScriptTag(TERRAIN_DESERT)), Map.entry("Grass", ScriptBrushPresets.createScriptTag(GRASS)), Map.entry("Kelp", ScriptBrushPresets.createScriptTag(KELP)), Map.entry("Heart", ScriptBrushPresets.createScriptTag(HEART)), Map.entry("Leafy Bushes", ScriptBrushPresets.createScriptTag(LEAFY_BUSHES)), Map.entry("Flowers", ScriptBrushPresets.createScriptTag(FLOWERS)), Map.entry("Vines", ScriptBrushPresets.createScriptTag(VINES)), Map.entry("Clear Foliage", ScriptBrushPresets.createScriptTag(CLEAR)));
    }

    private static class_2487 createScriptTag(String script) {
        class_2487 tag = new class_2487();
        script = script.replace("short_grass", "grass");
        script = script.replace("    ", "\t");
        tag.method_10582("Script", script);
        return tag;
    }
}

