/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modify;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.funcinterfaces.TriIntPredicate;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ModifyTwist {
    public static ChunkedBlockRegion twist(float angleDegrees, float axisX, float axisY, float axisZ, TriIntPredicate mask) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return null;
        }
        int offsetX = Math.floorDiv(max2.method_10263() + min2.method_10263(), 2);
        int offsetY = Math.floorDiv(max2.method_10264() + min2.method_10264(), 2);
        int offsetZ = Math.floorDiv(max2.method_10260() + min2.method_10260(), 2);
        float minDot = Float.MAX_VALUE;
        float maxDot = Float.MIN_VALUE;
        int minX = min2.method_10263();
        int minY = min2.method_10264();
        int minZ = min2.method_10260();
        int maxX = max2.method_10263();
        int maxY = max2.method_10264();
        int maxZ = max2.method_10260();
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    float dot = (float)(x - offsetX) * axisX + (float)(y - offsetY) * axisY + (float)(z - offsetZ) * axisZ;
                    minDot = Math.min(minDot, dot);
                    maxDot = Math.max(maxDot, dot);
                    if (z == maxZ) break;
                    z = maxZ;
                }
                if (y == maxY) break;
                y = maxY;
            }
            if (x == maxX) break;
            x = maxX;
        }
        if ((double)(maxDot - minDot) < 1.0E-4) {
            return null;
        }
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            return ModifyTwist.twistAABB(angleDegrees, axisX, axisY, axisZ, offsetX, offsetY, offsetZ, minDot, maxDot, mask);
        }
        if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            return ModifyTwist.twistSet(angleDegrees, axisX, axisY, axisZ, offsetX, offsetY, offsetZ, minDot, maxDot, mask, set);
        }
        return null;
    }

    private static ChunkedBlockRegion twistAABB(float angleDegrees, float axisX, float axisY, float axisZ, int offsetX, int offsetY, int offsetZ, float minDot, float maxDot, TriIntPredicate mask) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return null;
        }
        int minX = min2.method_10263();
        int minY = min2.method_10264();
        int minZ = min2.method_10260();
        int maxX = max2.method_10263();
        int maxY = max2.method_10264();
        int maxZ = max2.method_10260();
        ChunkedBlockRegion out = new ChunkedBlockRegion();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int newMinX = Integer.MAX_VALUE;
        int newMinY = Integer.MAX_VALUE;
        int newMinZ = Integer.MAX_VALUE;
        int newMaxX = Integer.MIN_VALUE;
        int newMaxY = Integer.MIN_VALUE;
        int newMaxZ = Integer.MIN_VALUE;
        Vector4f vector4f = new Vector4f();
        Matrix4f matrix = new Matrix4f();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    float dot = (float)(x - offsetX) * axisX + (float)(y - offsetY) * axisY + (float)(z - offsetZ) * axisZ;
                    float angle = (float)Math.toRadians(angleDegrees) * (dot - minDot) / (maxDot - minDot);
                    matrix.rotation(angle, axisX, axisY, axisZ);
                    if (mask.test(x, y, z)) {
                        out.addBlockIfNotPresent(x, y, z, class_2246.field_10124.method_9564());
                    }
                    vector4f.set((float)(x - offsetX), (float)(y - offsetY), (float)(z - offsetZ), 1.0f);
                    matrix.transform(vector4f);
                    newMinX = Math.min(newMinX, (int)Math.floor(vector4f.x));
                    newMinY = Math.min(newMinY, (int)Math.floor(vector4f.y));
                    newMinZ = Math.min(newMinZ, (int)Math.floor(vector4f.z));
                    newMaxX = Math.max(newMaxX, (int)Math.ceil(vector4f.x));
                    newMaxY = Math.max(newMaxY, (int)Math.ceil(vector4f.y));
                    newMaxZ = Math.max(newMaxZ, (int)Math.ceil(vector4f.z));
                }
            }
        }
        class_2350[] directions = class_2350.values();
        for (int x = newMinX; x <= newMaxX; ++x) {
            for (int y = newMinY; y <= newMaxY; ++y) {
                block5: for (int z = newMinZ; z <= newMaxZ; ++z) {
                    class_2680 blockState;
                    float dot = (float)x * axisX + (float)y * axisY + (float)z * axisZ;
                    float angle = (float)Math.toRadians(angleDegrees) * (dot - minDot) / (maxDot - minDot);
                    matrix.rotation(angle, axisX, axisY, axisZ);
                    matrix.invert();
                    vector4f.set((float)x, (float)y, (float)z, 1.0f);
                    matrix.transform(vector4f);
                    int fromX = Math.round(vector4f.x) + offsetX;
                    int fromY = Math.round(vector4f.y) + offsetY;
                    int fromZ = Math.round(vector4f.z) + offsetZ;
                    if (fromX >= minX && fromX <= maxX && fromY >= minY && fromY <= maxY && fromZ >= minZ && fromZ <= maxZ && !(blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(fromX, fromY, fromZ))).method_26215() && mask.test(x + offsetX, y + offsetY, z + offsetZ)) {
                        out.addBlockWithoutDirty(x + offsetX, y + offsetY, z + offsetZ, blockState);
                        continue;
                    }
                    float currFloatX = vector4f.x;
                    float currFloatY = vector4f.y;
                    float currFloatZ = vector4f.z;
                    for (class_2350 direction : directions) {
                        class_2680 neighborState;
                        int nx = direction.method_10148();
                        int ny = direction.method_10164();
                        int nz = direction.method_10165();
                        vector4f.set((float)(x + nx), (float)(y + ny), (float)(z + nz), 1.0f);
                        matrix.transform(vector4f);
                        int neighborFromX = Math.round(vector4f.x) + offsetX;
                        int neighborFromY = Math.round(vector4f.y) + offsetY;
                        int neighborFromZ = Math.round(vector4f.z) + offsetZ;
                        int manhattanDistance = Math.abs(neighborFromX - fromX) + Math.abs(neighborFromY - fromY) + Math.abs(neighborFromZ - fromZ);
                        if (manhattanDistance != 2) continue;
                        float avgX = (float)x + (float)nx / 2.0f;
                        float avgY = (float)y + (float)ny / 2.0f;
                        float avgZ = (float)z + (float)nz / 2.0f;
                        float dx = currFloatX - avgX;
                        float dy = currFloatY - avgY;
                        float dz = currFloatZ - avgZ;
                        float currDistanceSq = dx * dx + dy * dy + dz * dz;
                        if (currDistanceSq > (dx = vector4f.x - avgX) * dx + (dy = vector4f.y - avgY) * dy + (dz = vector4f.z - avgZ) * dz || !(neighborState = level.method_8320((class_2338)mutableBlockPos.method_10103(neighborFromX, neighborFromY, neighborFromZ))).method_26215()) continue;
                        int iterMinX = Math.min(fromX, neighborFromX);
                        int iterMaxX = Math.max(fromX, neighborFromX);
                        int iterMinY = Math.min(fromY, neighborFromY);
                        int iterMaxY = Math.max(fromY, neighborFromY);
                        int iterMinZ = Math.min(fromZ, neighborFromZ);
                        int iterMaxZ = Math.max(fromZ, neighborFromZ);
                        iterMinX = Math.max(iterMinX, minX);
                        iterMaxX = Math.min(iterMaxX, maxX);
                        iterMinY = Math.max(iterMinY, minY);
                        iterMaxY = Math.min(iterMaxY, maxY);
                        iterMinZ = Math.max(iterMinZ, minZ);
                        iterMaxZ = Math.min(iterMaxZ, maxZ);
                        class_2680 closestBlock = null;
                        float closestDistanceSq = Float.MAX_VALUE;
                        for (int x1 = iterMinX; x1 <= iterMaxX; ++x1) {
                            for (int y1 = iterMinY; y1 <= iterMaxY; ++y1) {
                                for (int z1 = iterMinZ; z1 <= iterMaxZ; ++z1) {
                                    class_2680 intermediate;
                                    if (x1 == fromX && y1 == fromY && z1 == fromZ || x1 == neighborFromX && y1 == neighborFromY && z1 == neighborFromZ || (intermediate = level.method_8320((class_2338)mutableBlockPos.method_10103(x1, y1, z1))).method_26215()) continue;
                                    dx = currFloatX - (float)x1;
                                    dy = currFloatY - (float)y1;
                                    dz = currFloatZ - (float)z1;
                                    float intermediateDistanceSq = dx * dx + dy * dy + dz * dz;
                                    if (closestBlock != null && !(intermediateDistanceSq < closestDistanceSq)) continue;
                                    closestBlock = intermediate;
                                    closestDistanceSq = intermediateDistanceSq;
                                }
                            }
                        }
                        if (closestBlock == null || closestBlock.method_26215() || !mask.test(x + offsetX, y + offsetY, z + offsetZ)) continue;
                        out.addBlockWithoutDirty(x + offsetX, y + offsetY, z + offsetZ, closestBlock);
                        continue block5;
                    }
                }
            }
        }
        return out;
    }

    private static ChunkedBlockRegion twistSet(float angleDegrees, float axisX, float axisY, float axisZ, int offsetX, int offsetY, int offsetZ, float minDot, float maxDot, TriIntPredicate mask, SelectionBuffer.Set set) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return null;
        }
        int minX = min2.method_10263();
        int minY = min2.method_10264();
        int minZ = min2.method_10260();
        int maxX = max2.method_10263();
        int maxY = max2.method_10264();
        int maxZ = max2.method_10260();
        ChunkedBlockRegion out = new ChunkedBlockRegion();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class MinMaxWrapper {
            int newMinX = Integer.MAX_VALUE;
            int newMinY = Integer.MAX_VALUE;
            int newMinZ = Integer.MAX_VALUE;
            int newMaxX = Integer.MIN_VALUE;
            int newMaxY = Integer.MIN_VALUE;
            int newMaxZ = Integer.MIN_VALUE;

            MinMaxWrapper() {
            }
        }
        MinMaxWrapper wrapper = new MinMaxWrapper();
        Vector4f vector4f = new Vector4f();
        Matrix4f matrix = new Matrix4f();
        set.forEach((x, y, z) -> {
            float dot = (float)(x - offsetX) * axisX + (float)(y - offsetY) * axisY + (float)(z - offsetZ) * axisZ;
            float angle = (float)Math.toRadians(angleDegrees) * (dot - minDot) / (maxDot - minDot);
            matrix.rotation(angle, axisX, axisY, axisZ);
            if (mask.test(x, y, z)) {
                out.addBlockIfNotPresent(x, y, z, class_2246.field_10124.method_9564());
            }
            vector4f.set((float)(x - offsetX), (float)(y - offsetY), (float)(z - offsetZ), 1.0f);
            matrix.transform(vector4f);
            wrapper.newMinX = Math.min(wrapper.newMinX, (int)Math.floor(vector4f.x));
            wrapper.newMinY = Math.min(wrapper.newMinY, (int)Math.floor(vector4f.y));
            wrapper.newMinZ = Math.min(wrapper.newMinZ, (int)Math.floor(vector4f.z));
            wrapper.newMaxX = Math.max(wrapper.newMaxX, (int)Math.ceil(vector4f.x));
            wrapper.newMaxY = Math.max(wrapper.newMaxY, (int)Math.ceil(vector4f.y));
            wrapper.newMaxZ = Math.max(wrapper.newMaxZ, (int)Math.ceil(vector4f.z));
        });
        int newMinX = wrapper.newMinX;
        int newMinY = wrapper.newMinY;
        int newMinZ = wrapper.newMinZ;
        int newMaxX = wrapper.newMaxX;
        int newMaxY = wrapper.newMaxY;
        int newMaxZ = wrapper.newMaxZ;
        class_2350[] directions = class_2350.values();
        for (int x2 = newMinX; x2 <= newMaxX; ++x2) {
            for (int y2 = newMinY; y2 <= newMaxY; ++y2) {
                block2: for (int z2 = newMinZ; z2 <= newMaxZ; ++z2) {
                    class_2680 blockState;
                    float dot = (float)x2 * axisX + (float)y2 * axisY + (float)z2 * axisZ;
                    float angle = (float)Math.toRadians(angleDegrees) * (dot - minDot) / (maxDot - minDot);
                    matrix.rotation(angle, axisX, axisY, axisZ);
                    matrix.invert();
                    vector4f.set((float)x2, (float)y2, (float)z2, 1.0f);
                    matrix.transform(vector4f);
                    int fromX = Math.round(vector4f.x) + offsetX;
                    int fromY = Math.round(vector4f.y) + offsetY;
                    int fromZ = Math.round(vector4f.z) + offsetZ;
                    if (set.contains(fromX, fromY, fromZ) && !(blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(fromX, fromY, fromZ))).method_26215() && mask.test(x2 + offsetX, y2 + offsetY, z2 + offsetZ)) {
                        out.addBlockWithoutDirty(x2 + offsetX, y2 + offsetY, z2 + offsetZ, blockState);
                        continue;
                    }
                    float currFloatX = vector4f.x;
                    float currFloatY = vector4f.y;
                    float currFloatZ = vector4f.z;
                    for (class_2350 direction : directions) {
                        class_2680 neighborState;
                        int nx = direction.method_10148();
                        int ny = direction.method_10164();
                        int nz = direction.method_10165();
                        vector4f.set((float)(x2 + nx), (float)(y2 + ny), (float)(z2 + nz), 1.0f);
                        matrix.transform(vector4f);
                        int neighborFromX = Math.round(vector4f.x) + offsetX;
                        int neighborFromY = Math.round(vector4f.y) + offsetY;
                        int neighborFromZ = Math.round(vector4f.z) + offsetZ;
                        int manhattanDistance = Math.abs(neighborFromX - fromX) + Math.abs(neighborFromY - fromY) + Math.abs(neighborFromZ - fromZ);
                        if (manhattanDistance != 2) continue;
                        float avgX = (float)x2 + (float)nx / 2.0f;
                        float avgY = (float)y2 + (float)ny / 2.0f;
                        float avgZ = (float)z2 + (float)nz / 2.0f;
                        float dx = currFloatX - avgX;
                        float dy = currFloatY - avgY;
                        float dz = currFloatZ - avgZ;
                        float currDistanceSq = dx * dx + dy * dy + dz * dz;
                        if (currDistanceSq > (dx = vector4f.x - avgX) * dx + (dy = vector4f.y - avgY) * dy + (dz = vector4f.z - avgZ) * dz || !(neighborState = level.method_8320((class_2338)mutableBlockPos.method_10103(neighborFromX, neighborFromY, neighborFromZ))).method_26215()) continue;
                        int iterMinX = Math.min(fromX, neighborFromX);
                        int iterMaxX = Math.max(fromX, neighborFromX);
                        int iterMinY = Math.min(fromY, neighborFromY);
                        int iterMaxY = Math.max(fromY, neighborFromY);
                        int iterMinZ = Math.min(fromZ, neighborFromZ);
                        int iterMaxZ = Math.max(fromZ, neighborFromZ);
                        class_2680 closestBlock = null;
                        float closestDistanceSq = Float.MAX_VALUE;
                        for (int x1 = iterMinX; x1 <= iterMaxX; ++x1) {
                            for (int y1 = iterMinY; y1 <= iterMaxY; ++y1) {
                                for (int z1 = iterMinZ; z1 <= iterMaxZ; ++z1) {
                                    class_2680 intermediate;
                                    if (x1 == fromX && y1 == fromY && z1 == fromZ || x1 == neighborFromX && y1 == neighborFromY && z1 == neighborFromZ || !set.contains(x1, y1, z1) || (intermediate = level.method_8320((class_2338)mutableBlockPos.method_10103(x1, y1, z1))).method_26215()) continue;
                                    dx = currFloatX - (float)x1;
                                    dy = currFloatY - (float)y1;
                                    dz = currFloatZ - (float)z1;
                                    float intermediateDistanceSq = dx * dx + dy * dy + dz * dz;
                                    if (closestBlock != null && !(intermediateDistanceSq < closestDistanceSq)) continue;
                                    closestBlock = intermediate;
                                    closestDistanceSq = intermediateDistanceSq;
                                }
                            }
                        }
                        if (closestBlock == null || closestBlock.method_26215() || !mask.test(x2 + offsetX, y2 + offsetY, z2 + offsetZ)) continue;
                        out.addBlockWithoutDirty(x2 + offsetX, y2 + offsetY, z2 + offsetZ, closestBlock);
                        continue block2;
                    }
                }
            }
        }
        return out;
    }
}

