/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.generator;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.generator.TreeGeneration;
import com.moulberry.axiom.utils.RegionHelper;
import java.text.NumberFormat;
import java.util.EnumSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class GeneratorTool
implements Tool {
    private int[] generationType = new int[]{0};

    @Override
    public void reset() {
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.rightClick();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public void rightClick() {
        ChunkedBlockRegion chunkedBlockRegion;
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return;
        }
        class_2338 start = result.blockPos();
        int type2 = this.generationType[0];
        if (type2 == 0) {
            chunkedBlockRegion = TreeGeneration.generateAsh((class_1937)class_310.method_1551().field_1687, start.method_10093(result.direction()));
        } else if (type2 == 1) {
            chunkedBlockRegion = TreeGeneration.generateCyprus((class_1937)class_310.method_1551().field_1687, start.method_10093(result.direction()));
        } else {
            return;
        }
        int count = chunkedBlockRegion.count();
        if (count == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(count);
        String historyDescription = AxiomI18n.get("axiom.history_description.floodfilled", countString);
        RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription);
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.combo("Type", this.generationType, new String[]{"Ash", "Cyprus"});
    }

    @Override
    public String name() {
        return "Generator";
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
    }

    @Override
    public char iconChar() {
        return '\ue919';
    }

    @Override
    public String keybindId() {
        return "generator";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        throw new UnsupportedOperationException();
    }
}

