/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class RegularPolygonRasterization {
    public static void regularPolygon(Vector3i center, float diameterX, float diameterZ, boolean hollow, boolean centerEvenDiameters, int vertices, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0.0f || diameterZ <= 0.0f) {
            return;
        }
        if (vertices < 3) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        double radiusX = (double)(diameterX - 1.0f) / 2.0;
        double radiusZ = (double)(diameterZ - 1.0f) / 2.0;
        if (hollow) {
            double offsetX = (centerEvenDiameters ? radiusX % 1.0 : 0.0) + 0.5;
            double offsetZ = (centerEvenDiameters ? radiusZ % 1.0 : 0.0) + 0.5;
            Vector3d from = new Vector3d(offsetX, 0.5, radiusZ + offsetZ);
            quaternionf.transformInverse(from);
            Vector3d to = new Vector3d();
            for (int a = 1; a <= vertices; ++a) {
                double currX = Math.sin((double)a * Math.PI * 2.0 / (double)vertices) * (radiusX - 0.15) + offsetX;
                double currZ = Math.cos((double)a * Math.PI * 2.0 / (double)vertices) * (radiusZ - 0.15) + offsetZ;
                to.set(currX, 0.5, currZ);
                quaternionf.transformInverse(to);
                Rasterization3D.dda(from, to, (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ));
                Vector3d temp = from;
                from = to;
                to = temp;
            }
        } else {
            double[] lineSegments = new double[2 * (vertices + 1)];
            for (int a = 0; a <= vertices; ++a) {
                double x2 = (double)((float)Math.sin((double)a * Math.PI * 2.0 / (double)vertices)) * (radiusX + 0.5);
                double z2 = (double)((float)Math.cos((double)a * Math.PI * 2.0 / (double)vertices)) * (radiusZ + 0.5);
                lineSegments[a * 2] = x2;
                lineSegments[a * 2 + 1] = z2;
            }
            RasterizationHelper.planeCondition(center, diameterX, diameterZ, centerEvenDiameters, quaternionf, (x, y) -> {
                for (int i = 0; i < lineSegments.length - 2; i += 2) {
                    double x2 = lineSegments[i + 2];
                    double x1 = lineSegments[i];
                    double y1 = lineSegments[i + 1];
                    double y2 = lineSegments[i + 3];
                    if (!((x2 - x1) * ((double)y - y1) - (y2 - y1) * ((double)x - x1) > 0.0)) continue;
                    return false;
                }
                return true;
            }, consumer);
        }
    }
}

