/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations.smooth;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.RegionHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.text.NumberFormat;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class SmoothSnow {
    public static void smoothSnow() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            SmoothSnow.smoothSnow(aabb);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            SmoothSnow.smoothSnow(set);
        }
    }

    private static void smoothSnow(SelectionBuffer.AABB aabb) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        Position2dToIntMap heightmap = new Position2dToIntMap(Integer.MIN_VALUE);
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26204() == class_2246.field_10477) {
                        blockRegion.addBlock(x, y, z, class_2246.field_10124.method_9564());
                        class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z));
                        if (!below.method_28498((class_2769)class_2741.field_12512)) continue;
                        blockRegion.addBlock(x, y - 1, z, (class_2680)below.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    if (!blockState.method_51366()) continue;
                    if (y == maxY) {
                        heightmap.put(x, z, Integer.MAX_VALUE);
                        continue;
                    }
                    heightmap.max(x, z, y);
                }
            }
        }
        SmoothSnow.doSmoothSnow(heightmap, minX, maxX, minZ, maxZ, blockRegion);
    }

    private static void smoothSnow(SelectionBuffer.Set set) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        Position2dToIntMap heightmap = new Position2dToIntMap(Integer.MIN_VALUE);
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        set.forEach((arg_0, arg_1, arg_2) -> SmoothSnow.lambda$smoothSnow$0((class_1937)level, mutableBlockPos, blockRegion, heightmap, arg_0, arg_1, arg_2));
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Long2ObjectMap.Entry entry : heightmap.unsafeGetMap().long2ObjectEntrySet()) {
            int cx = class_1923.method_8325((long)entry.getLongKey()) * 16;
            int cz = class_1923.method_8332((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int v = ((int[])entry.getValue())[index];
                    if (v != Integer.MIN_VALUE) {
                        if (!set.contains(cx + x, v + 1, cz + z)) {
                            ((int[])entry.getValue())[index] = Integer.MAX_VALUE;
                        } else {
                            if (cx + x < minX) {
                                minX = cx + x;
                            }
                            if (cz + z < minZ) {
                                minZ = cz + z;
                            }
                            if (cx + x > maxX) {
                                maxX = cx + x;
                            }
                            if (cz + z > maxZ) {
                                maxZ = cz + z;
                            }
                        }
                    }
                    ++index;
                }
            }
        }
        if (maxX < minX || maxZ < minZ) {
            return;
        }
        SmoothSnow.doSmoothSnow(heightmap, minX, maxX, minZ, maxZ, blockRegion);
    }

    private static void doSmoothSnow(Position2dToIntMap heightmap, int minX, int maxX, int minZ, int maxZ, ChunkedBlockRegion blockRegion) {
        int layers;
        float amount;
        int leftOffset;
        int currRightSnowHeight;
        int lowerDistance;
        int upperDistance;
        int index;
        int layers2;
        int leftOffset2;
        int adjustment;
        int y;
        int currLeftSnowHeight;
        int leftY;
        int leftSnowHeight;
        int y2;
        int z;
        int x;
        int neighborZ;
        int neighborX;
        int least;
        int heightNeighborPZ;
        int heightNeighborPX;
        int height;
        int index2;
        int z2;
        int x2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_638 level = class_310.method_1551().field_1687;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        int[] distancesUpper = new int[(sizeX + 2) * (sizeZ + 2)];
        Arrays.fill(distancesUpper, Integer.MAX_VALUE);
        int[] distancesLower = new int[(sizeX + 2) * (sizeZ + 2)];
        Arrays.fill(distancesLower, Integer.MAX_VALUE);
        int xIndexOffset = sizeZ + 2;
        int zIndexOffset = 1;
        for (x2 = 0; x2 < sizeX; ++x2) {
            for (z2 = 0; z2 < sizeZ; ++z2) {
                int neighbor;
                int least2;
                index2 = (x2 + 1) * xIndexOffset + (z2 + 1) * zIndexOffset;
                height = heightmap.get(minX + x2, minZ + z2);
                heightNeighborPX = heightmap.get(minX + x2 + 1, minZ + z2);
                heightNeighborPZ = heightmap.get(minX + x2, minZ + z2 + 1);
                int heightNeighborNX = heightmap.get(minX + x2 - 1, minZ + z2);
                int heightNeighborNZ = heightmap.get(minX + x2, minZ + z2 - 1);
                int minNeighborHeight = Math.min(heightNeighborPX, Math.min(heightNeighborPZ, Math.min(heightNeighborNX, heightNeighborNZ)));
                boolean hasUpperNeighbor = false;
                if (heightNeighborPX > height && level.method_8320((class_2338)mutableBlockPos.method_10103(minX + x2 + 1, height + 1, minZ + z2)).method_51366()) {
                    hasUpperNeighbor = true;
                } else if (heightNeighborPZ > height && level.method_8320((class_2338)mutableBlockPos.method_10103(minX + x2, height + 1, minZ + z2 + 1)).method_51366()) {
                    hasUpperNeighbor = true;
                } else if (heightNeighborNX > height && level.method_8320((class_2338)mutableBlockPos.method_10103(minX + x2 - 1, height + 1, minZ + z2)).method_51366()) {
                    hasUpperNeighbor = true;
                } else if (heightNeighborNZ > height && level.method_8320((class_2338)mutableBlockPos.method_10103(minX + x2, height + 1, minZ + z2 - 1)).method_51366()) {
                    hasUpperNeighbor = true;
                }
                if (hasUpperNeighbor) {
                    distancesUpper[index2] = 1;
                } else {
                    least2 = Integer.MAX_VALUE;
                    if (heightNeighborNX == height && (neighbor = distancesUpper[index2 - xIndexOffset]) != Integer.MAX_VALUE && neighbor + 1 < least2) {
                        least2 = neighbor + 1;
                    }
                    if (heightNeighborNZ == height && (neighbor = distancesUpper[index2 - zIndexOffset]) != Integer.MAX_VALUE && neighbor + 1 < least2) {
                        least2 = neighbor + 1;
                    }
                    distancesUpper[index2] = least2;
                }
                if (minNeighborHeight < height) {
                    distancesLower[index2] = 1;
                    continue;
                }
                least2 = Integer.MAX_VALUE;
                if (heightNeighborNX == height && (neighbor = distancesLower[index2 - xIndexOffset]) != Integer.MAX_VALUE && neighbor + 1 < least2) {
                    least2 = neighbor + 1;
                }
                if (heightNeighborNZ == height && (neighbor = distancesLower[index2 - zIndexOffset]) != Integer.MAX_VALUE && neighbor + 1 < least2) {
                    least2 = neighbor + 1;
                }
                distancesLower[index2] = least2;
            }
        }
        for (x2 = sizeX - 1; x2 >= 0; --x2) {
            for (z2 = sizeZ - 1; z2 >= 0; --z2) {
                index2 = (x2 + 1) * xIndexOffset + (z2 + 1) * zIndexOffset;
                height = heightmap.get(minX + x2, minZ + z2);
                heightNeighborPX = heightmap.get(minX + x2 + 1, minZ + z2);
                heightNeighborPZ = heightmap.get(minX + x2, minZ + z2 + 1);
                least = distancesUpper[index2];
                if (heightNeighborPX == height && (neighborX = distancesUpper[index2 + xIndexOffset]) != Integer.MAX_VALUE && neighborX + 1 < least) {
                    least = neighborX + 1;
                }
                if (heightNeighborPZ == height && (neighborZ = distancesUpper[index2 + zIndexOffset]) != Integer.MAX_VALUE && neighborZ + 1 < least) {
                    least = neighborZ + 1;
                }
                distancesUpper[index2] = least;
                least = distancesLower[index2];
                if (heightNeighborPX == height && (neighborX = distancesLower[index2 + xIndexOffset]) != Integer.MAX_VALUE && neighborX + 1 < least) {
                    least = neighborX + 1;
                }
                if (heightNeighborPZ == height && (neighborZ = distancesLower[index2 + zIndexOffset]) != Integer.MAX_VALUE && neighborZ + 1 < least) {
                    least = neighborZ + 1;
                }
                distancesLower[index2] = least;
            }
        }
        for (x2 = 0; x2 < sizeX; ++x2) {
            for (z2 = 0; z2 < sizeZ; ++z2) {
                index2 = (x2 + 1) * xIndexOffset + (z2 + 1) * zIndexOffset;
                height = heightmap.get(minX + x2, minZ + z2);
                int heightNeighborNX = heightmap.get(minX + x2 - 1, minZ + z2);
                int heightNeighborNZ = heightmap.get(minX + x2, minZ + z2 - 1);
                least = distancesUpper[index2];
                if (heightNeighborNX == height && (neighborX = distancesUpper[index2 - xIndexOffset]) != Integer.MAX_VALUE && neighborX + 1 < least) {
                    least = neighborX + 1;
                }
                if (heightNeighborNZ == height && (neighborZ = distancesUpper[index2 - zIndexOffset]) != Integer.MAX_VALUE && neighborZ + 1 < least) {
                    least = neighborZ + 1;
                }
                distancesUpper[index2] = least;
                least = distancesLower[index2];
                if (heightNeighborNX == height && (neighborX = distancesLower[index2 - xIndexOffset]) != Integer.MAX_VALUE && neighborX + 1 < least) {
                    least = neighborX + 1;
                }
                if (heightNeighborNZ == height && (neighborZ = distancesLower[index2 - zIndexOffset]) != Integer.MAX_VALUE && neighborZ + 1 < least) {
                    least = neighborZ + 1;
                }
                distancesLower[index2] = least;
            }
        }
        for (x2 = sizeX - 1; x2 >= 0; --x2) {
            for (z2 = sizeZ - 1; z2 >= 0; --z2) {
                index2 = (x2 + 1) * xIndexOffset + (z2 + 1) * zIndexOffset;
                height = heightmap.get(minX + x2, minZ + z2);
                heightNeighborPX = heightmap.get(minX + x2 + 1, minZ + z2);
                heightNeighborPZ = heightmap.get(minX + x2, minZ + z2 + 1);
                least = distancesUpper[index2];
                if (heightNeighborPX == height && (neighborX = distancesUpper[index2 + xIndexOffset]) != Integer.MAX_VALUE && neighborX + 1 < least) {
                    least = neighborX + 1;
                }
                if (heightNeighborPZ == height && (neighborZ = distancesUpper[index2 + zIndexOffset]) != Integer.MAX_VALUE && neighborZ + 1 < least) {
                    least = neighborZ + 1;
                }
                distancesUpper[index2] = least;
                least = distancesLower[index2];
                if (heightNeighborPX == height && (neighborX = distancesLower[index2 + xIndexOffset]) != Integer.MAX_VALUE && neighborX + 1 < least) {
                    least = neighborX + 1;
                }
                if (heightNeighborPZ == height && (neighborZ = distancesLower[index2 + zIndexOffset]) != Integer.MAX_VALUE && neighborZ + 1 < least) {
                    least = neighborZ + 1;
                }
                distancesLower[index2] = least;
            }
        }
        int[][] distanceLookup = new int[][]{{4}, {2, 6}, {1, 3, 6}, {1, 3, 5, 7}, {1, 3, 4, 5, 7}, {1, 2, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 4, 5, 6, 7}};
        Position2dToIntMap snowHeight = new Position2dToIntMap(Integer.MIN_VALUE);
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                y2 = heightmap.get(x, z);
                if (y2 == Integer.MIN_VALUE || y2 == Integer.MAX_VALUE) continue;
                ++y2;
                int index3 = (x - minX + 1) * xIndexOffset + (z - minZ + 1) * zIndexOffset;
                int upperDistance2 = distancesUpper[index3];
                int lowerDistance2 = distancesLower[index3];
                if (upperDistance2 == Integer.MAX_VALUE) {
                    if (lowerDistance2 == Integer.MAX_VALUE) continue;
                    snowHeight.put(x, z, Math.min(8, lowerDistance2));
                    continue;
                }
                if (lowerDistance2 == Integer.MAX_VALUE) {
                    snowHeight.put(x, z, 9 - Math.min(8, upperDistance2));
                    continue;
                }
                float layers1 = lowerDistance2 + upperDistance2 >= 8 ? (float)(lowerDistance2 - 1) / (float)(lowerDistance2 + upperDistance2 - 2) * 7.0f + 1.0f : (float)distanceLookup[lowerDistance2 + upperDistance2 - 2][lowerDistance2 - 1];
                int layers3 = Math.round(layers1);
                if (layers3 < 1) {
                    layers3 = 1;
                }
                if (layers3 > 8) {
                    layers3 = 8;
                }
                snowHeight.put(x, z, layers3);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            int minHalfZ = Integer.MIN_VALUE;
            int minHalfZPosY = Integer.MIN_VALUE;
            leftSnowHeight = 0;
            leftY = Integer.MIN_VALUE;
            currLeftSnowHeight = 0;
            int currLeftY = Integer.MIN_VALUE;
            for (int z3 = minZ; z3 <= maxZ; ++z3) {
                y = heightmap.get(x, z3);
                if (y == Integer.MIN_VALUE || y == Integer.MAX_VALUE) continue;
                if (minHalfZ != Integer.MIN_VALUE && minHalfZPosY != ++y) {
                    adjustment = 0;
                    if (currLeftY < minHalfZPosY && y < minHalfZPosY) {
                        adjustment = 1;
                    } else if (currLeftY > minHalfZPosY && y > minHalfZPosY) {
                        adjustment = -1;
                    }
                    for (int z22 = minHalfZ; z22 < z3; ++z22) {
                        leftOffset2 = currLeftY == minHalfZPosY ? 1 : 0;
                        float amount2 = (float)(z22 - minHalfZ + leftOffset2) / (float)(z3 - 1 - minHalfZ + leftOffset2);
                        if ((double)amount2 < 0.5) {
                            layers2 = currLeftY < minHalfZPosY ? Math.round(4.0f * amount2 + 2.0f * (1.0f - amount2)) : (currLeftY > minHalfZPosY ? Math.round(4.0f * amount2 + 6.0f * (1.0f - amount2)) : Math.round(4.0f * (amount2 *= 2.0f) + (float)currLeftSnowHeight * (1.0f - amount2)));
                        } else if ((double)amount2 > 0.5) {
                            amount2 = 2.0f - amount2 * 2.0f;
                            layers2 = y < minHalfZPosY ? Math.round(4.0f * amount2 + 2.0f * (1.0f - amount2)) : Math.round(4.0f * amount2 + 6.0f * (1.0f - amount2));
                        } else {
                            layers2 = 4;
                        }
                        snowHeight.put(x, z22, layers2 + adjustment);
                    }
                    minHalfZ = Integer.MIN_VALUE;
                }
                index = (x - minX + 1) * xIndexOffset + (z3 - minZ + 1) * zIndexOffset;
                upperDistance = distancesUpper[index];
                lowerDistance = distancesLower[index];
                int minusX = heightmap.get(x - 1, z3) + 1;
                int plusX = heightmap.get(x + 1, z3) + 1;
                if (upperDistance + lowerDistance <= 2 && minusX != y && plusX != y && minusX < y != plusX < y) {
                    if (minHalfZ == Integer.MIN_VALUE) {
                        minHalfZ = z3;
                        minHalfZPosY = y;
                        currLeftSnowHeight = leftSnowHeight;
                        currLeftY = leftY;
                    }
                } else if (minHalfZ != Integer.MIN_VALUE) {
                    currRightSnowHeight = snowHeight.get(x, z3);
                    for (int z23 = minHalfZ; z23 < z3; ++z23) {
                        leftOffset = currLeftY == minHalfZPosY ? 1 : 0;
                        amount = (float)(z23 - minHalfZ + leftOffset) / (float)(z3 - 1 - minHalfZ + leftOffset + 1);
                        if ((double)amount < 0.5) {
                            layers = currLeftY < minHalfZPosY ? Math.round(4.0f * amount + 2.0f * (1.0f - amount)) : (currLeftY > minHalfZPosY ? Math.round(4.0f * amount + 6.0f * (1.0f - amount)) : Math.round(4.0f * (amount *= 2.0f) + (float)currLeftSnowHeight * (1.0f - amount)));
                        } else if ((double)amount > 0.5) {
                            amount = 2.0f - amount * 2.0f;
                            layers = Math.round(4.0f * amount + (float)currRightSnowHeight * (1.0f - amount));
                        } else {
                            layers = 4;
                        }
                        snowHeight.put(x, z23, layers);
                    }
                    minHalfZ = Integer.MIN_VALUE;
                }
                leftSnowHeight = snowHeight.get(x, z3);
                leftY = y;
            }
        }
        for (int z4 = minZ; z4 <= maxZ; ++z4) {
            int minHalfX = Integer.MIN_VALUE;
            int minHalfXPosY = Integer.MIN_VALUE;
            leftSnowHeight = 0;
            leftY = Integer.MIN_VALUE;
            currLeftSnowHeight = 0;
            int currLeftY = Integer.MIN_VALUE;
            for (int x3 = minX; x3 <= maxX; ++x3) {
                y = heightmap.get(x3, z4);
                if (y == Integer.MIN_VALUE || y == Integer.MAX_VALUE) continue;
                if (minHalfX != Integer.MIN_VALUE && minHalfXPosY != ++y) {
                    adjustment = 0;
                    if (currLeftY < minHalfXPosY && y < minHalfXPosY) {
                        adjustment = 1;
                    } else if (currLeftY > minHalfXPosY && y > minHalfXPosY) {
                        adjustment = -1;
                    }
                    if (x3 - minHalfX >= 2) {
                        for (int x22 = minHalfX; x22 < x3; ++x22) {
                            leftOffset2 = currLeftY == minHalfXPosY ? 1 : 0;
                            float amount3 = (float)(x22 - minHalfX + leftOffset2) / (float)(x3 - 1 - minHalfX + leftOffset2);
                            if ((double)amount3 < 0.5) {
                                layers2 = currLeftY < minHalfXPosY ? Math.round(4.0f * amount3 + 2.0f * (1.0f - amount3)) : (currLeftY > minHalfXPosY ? Math.round(4.0f * amount3 + 6.0f * (1.0f - amount3)) : Math.round(4.0f * (amount3 *= 2.0f) + (float)currLeftSnowHeight * (1.0f - amount3)));
                            } else if ((double)amount3 > 0.5) {
                                amount3 = 2.0f - amount3 * 2.0f;
                                layers2 = y < minHalfXPosY ? Math.round(4.0f * amount3 + 2.0f * (1.0f - amount3)) : Math.round(4.0f * amount3 + 6.0f * (1.0f - amount3));
                            } else {
                                layers2 = 4;
                            }
                            snowHeight.put(x22, z4, layers2 + adjustment);
                        }
                    }
                    minHalfX = Integer.MIN_VALUE;
                }
                index = (x3 - minX + 1) * xIndexOffset + (z4 - minZ + 1) * zIndexOffset;
                upperDistance = distancesUpper[index];
                lowerDistance = distancesLower[index];
                int minusZ = heightmap.get(x3, z4 - 1) + 1;
                int plusZ = heightmap.get(x3, z4 + 1) + 1;
                if (upperDistance + lowerDistance <= 2 && minusZ != y && plusZ != y && minusZ < y != plusZ < y) {
                    if (minHalfX == Integer.MIN_VALUE) {
                        minHalfX = x3;
                        minHalfXPosY = y;
                        currLeftSnowHeight = leftSnowHeight;
                        currLeftY = leftY;
                    }
                } else if (minHalfX != Integer.MIN_VALUE) {
                    if (x3 - minHalfX >= 2) {
                        currRightSnowHeight = snowHeight.get(x3, z4);
                        for (int x23 = minHalfX; x23 < x3; ++x23) {
                            leftOffset = currLeftY == minHalfXPosY ? 1 : 0;
                            amount = (float)(x23 - minHalfX + leftOffset) / (float)(x3 - 1 - minHalfX + leftOffset + 1);
                            if ((double)amount < 0.5) {
                                layers = currLeftY < minHalfXPosY ? Math.round(4.0f * amount + 2.0f * (1.0f - amount)) : (currLeftY > minHalfXPosY ? Math.round(4.0f * amount + 6.0f * (1.0f - amount)) : Math.round(4.0f * (amount *= 2.0f) + (float)currLeftSnowHeight * (1.0f - amount)));
                            } else if ((double)amount > 0.5) {
                                amount = 2.0f - amount * 2.0f;
                                layers = Math.round(4.0f * amount + (float)currRightSnowHeight * (1.0f - amount));
                            } else {
                                layers = 4;
                            }
                            snowHeight.put(x23, z4, layers);
                        }
                    }
                    minHalfX = Integer.MIN_VALUE;
                }
                leftSnowHeight = snowHeight.get(x3, z4);
                leftY = y;
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                int snowHeightValue;
                class_2680 replacingBlock;
                y2 = heightmap.get(x, z);
                if (y2 == Integer.MIN_VALUE || y2 == Integer.MAX_VALUE || !(replacingBlock = level.method_8320((class_2338)mutableBlockPos.method_10103(x, ++y2, z))).method_26215() && replacingBlock.method_26204() != class_2246.field_10477 || (snowHeightValue = snowHeight.get(x, z)) < 1 || snowHeightValue > 8) continue;
                blockRegion.addBlock(x, y2, z, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(snowHeightValue)));
                class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y2 - 1, z));
                if (!below.method_28498((class_2769)class_2741.field_12512)) continue;
                blockRegion.addBlock(x, y2 - 1, z, (class_2680)below.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true)));
            }
        }
        String blockCountString = NumberFormat.getNumberInstance().format(blockRegion.count());
        RegionHelper.pushBlockRegionChange(blockRegion, "Smooth Snow (" + blockCountString + " blocks)");
    }

    private static /* synthetic */ void lambda$smoothSnow$0(class_1937 level, class_2338.class_2339 mutableBlockPos, ChunkedBlockRegion blockRegion, Position2dToIntMap heightmap, int x, int y, int z) {
        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (blockState.method_26204() == class_2246.field_10477) {
            blockRegion.addBlock(x, y, z, class_2246.field_10124.method_9564());
            class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z));
            if (below.method_28498((class_2769)class_2741.field_12512)) {
                blockRegion.addBlock(x, y - 1, z, (class_2680)below.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(false)));
            }
            if (below.method_51366() && below.method_26204() != class_2246.field_10477) {
                heightmap.max(x, z, y - 1);
            }
        } else if (blockState.method_51366()) {
            heightmap.max(x, z, y);
        } else {
            class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z));
            if (below.method_51366() && below.method_26204() != class_2246.field_10477) {
                heightmap.max(x, z, y - 1);
            }
        }
    }
}

