/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.clipboard_installation;

import com.moulberry.axiom.editor.clipboard_installation.ClipboardInstallationTask;
import com.moulberry.axiom.editor.styles.StyleHelper;
import com.moulberry.axiom.editor.styles.StyleManager;
import imgui.ImGui;
import java.util.Objects;

public class ClipboardInstallThemeTask
implements ClipboardInstallationTask {
    private final String name;
    private final String value;
    private final String confirmationMessage;
    private boolean finished = false;

    public ClipboardInstallThemeTask(String name, String value) {
        this.name = name;
        this.value = value;
        this.confirmationMessage = "Do you want to install the theme '" + this.name;
    }

    @Override
    public void renderConfirmationPopup() {
        ImGui.textWrapped(this.confirmationMessage);
    }

    @Override
    public void start() {
        if (this.finished) {
            return;
        }
        StyleHelper.Theme theme = StyleHelper.Theme.convertFromBase64(this.value);
        if (theme != null) {
            StyleManager.loadTheme(theme);
        }
        this.finished = true;
    }

    @Override
    public float progress() {
        return 0.0f;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public Exception getException() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClipboardInstallThemeTask that = (ClipboardInstallThemeTask)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }
}

