/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.moulberry.axiom.DefaultBlocks;
import com.moulberry.axiom.block_maps.BlockColourComputation;
import com.moulberry.axiom.block_maps.SpaceLookup;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2366;
import net.minecraft.class_2372;
import net.minecraft.class_2384;
import net.minecraft.class_2397;
import net.minecraft.class_2426;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_4696;
import net.minecraft.class_7923;

public class BlockColourMap {
    public static int FLAG_SOLID = 1;
    public static int FLAG_OPAQUE = 2;
    public static int FLAG_FULL_CUBE = 4;
    public static int FLAG_SAME_TEXTURE = 8;
    public static int FLAG_NO_ORES = 16;
    public static int FLAG_NO_GLAZED_TERRACOTTA = 32;
    public static int FLAG_NO_TILE_ENTITIES = 64;
    private static final SpaceLookup<class_2680> tree = new SpaceLookup();
    private static final Map<CustomBlock, class_243> colourMap = new HashMap<CustomBlock, class_243>();
    private static final Set<CustomBlock> sameTextureSet = new HashSet<CustomBlock>();
    private static boolean coloursDirty = true;
    private static int lastTreeFlags = -1;

    private static void recalculateColours() {
        class_2680 defaultState;
        if (!coloursDirty) {
            return;
        }
        coloursDirty = false;
        colourMap.clear();
        sameTextureSet.clear();
        LinkedHashSet<class_2680> blockStates = new LinkedHashSet<class_2680>();
        for (CustomBlock block : ServerCustomBlocks.customBlockMap.values()) {
            defaultState = block.axiom$defaultCustomState().getVanillaState();
            blockStates.add(defaultState);
        }
        for (CustomBlock block : class_7923.field_41175) {
            defaultState = DefaultBlocks.forBlock((class_2248)block);
            blockStates.add(defaultState);
        }
        List<BlockColourComputation.BlockColourResult> results = BlockColourComputation.calculateColours(blockStates);
        for (BlockColourComputation.BlockColourResult result : results) {
            CustomBlock customBlock = ServerCustomBlocks.getCustomOrVanillaStateFor(result.blockState()).getCustomBlock();
            class_243 lab = new class_243(result.l(), result.a(), result.b());
            colourMap.put(customBlock, lab);
            if (result.numTextures() > 1) continue;
            sameTextureSet.add(customBlock);
        }
    }

    private static void recalculateTree(int flags) {
        BlockColourMap.recalculateColours();
        if (lastTreeFlags == flags) {
            return;
        }
        lastTreeFlags = flags;
        tree.clear();
        for (Map.Entry<CustomBlock, class_243> entry : colourMap.entrySet()) {
            CustomBlock block = entry.getKey();
            class_243 lab = entry.getValue();
            class_2680 defaultState = block.axiom$defaultCustomState().getVanillaState();
            if (defaultState.method_26217() != class_2464.field_11458 || BlockColourMap.isHardIgnore(defaultState.method_26204()) || (flags & FLAG_SOLID) != 0 && !BlockColourMap.isSolid(defaultState) || (flags & FLAG_OPAQUE) != 0 && !BlockColourMap.isOpaque(defaultState) || (flags & FLAG_FULL_CUBE) != 0 && !BlockColourMap.isFullCube(defaultState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980)) || (flags & FLAG_SAME_TEXTURE) != 0 && !sameTextureSet.contains(block) || (flags & FLAG_NO_ORES) != 0 && BlockColourMap.isOre(defaultState) || (flags & FLAG_NO_GLAZED_TERRACOTTA) != 0 && BlockColourMap.isGlazedTerracotta(defaultState) || (flags & FLAG_NO_TILE_ENTITIES) != 0 && BlockColourMap.isTileEntity(defaultState)) continue;
            tree.edit(lab, old -> {
                if (old != null) {
                    String oldName = old.method_26204().method_40142().method_40237().method_29177().method_12832();
                    String newName = defaultState.method_26204().method_40142().method_40237().method_29177().method_12832();
                    if (oldName.length() <= newName.length()) {
                        return old;
                    }
                    return defaultState;
                }
                return defaultState;
            });
        }
    }

    public static void invalidateCache() {
        colourMap.clear();
        tree.clear();
        coloursDirty = true;
        lastTreeFlags = -1;
    }

    private static boolean isSolid(class_2680 blockState) {
        return blockState.method_51366();
    }

    private static boolean isOpaque(class_2680 blockState) {
        return (class_4696.method_23679((class_2680)blockState) == class_1921.method_23577() || blockState.method_26204() instanceof class_2372) && !(blockState.method_26204() instanceof class_2397);
    }

    private static boolean isFullCube(class_265 shape) {
        return shape == class_259.method_1077();
    }

    private static boolean isOre(class_2680 blockState) {
        return blockState.method_26204().method_40142().method_40237().method_29177().method_12832().contains("_ore");
    }

    private static boolean isGlazedTerracotta(class_2680 blockState) {
        return blockState.method_26204() instanceof class_2366 || blockState.method_26204().method_40142().method_40237().method_29177().method_12832().contains("_glazed_terracotta");
    }

    private static boolean isTileEntity(class_2680 blockState) {
        return blockState.method_31709() || blockState.method_26204() instanceof class_2426;
    }

    public static boolean isHardIgnore(class_2248 block) {
        return block instanceof class_2384 || block == class_2246.field_22113;
    }

    public static boolean isFullSolidOpaque(class_2680 blockState) {
        return blockState.method_26217() == class_2464.field_11458 && BlockColourMap.isFullCube(blockState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980)) && BlockColourMap.isSolid(blockState) && BlockColourMap.isOpaque(blockState);
    }

    public static class_243 getLab(class_2248 block) {
        BlockColourMap.recalculateColours();
        return colourMap.get((CustomBlock)block);
    }

    public static class_243 getLab(CustomBlock block) {
        BlockColourMap.recalculateColours();
        return colourMap.get(block);
    }

    public static class_2680 getNearestLab(double l, double a, double b, int flags) {
        BlockColourMap.recalculateTree(flags);
        return tree.nearest(new class_243(l, a, b));
    }

    public static List<class_2680> getNearestLabN(double l, double a, double b, int flags, int count) {
        BlockColourMap.recalculateTree(flags);
        return tree.nearestN(new class_243(l, a, b), count);
    }
}

