/*
 * Decompiled with CFR 0.152.
 */
package elocindev.animation_overhaul.config.utils;

import elocindev.animation_overhaul.AnimationOverhaul;
import elocindev.animation_overhaul.config.AnimationsConfig;
import elocindev.animation_overhaul.config.PlayerConfig;
import elocindev.animation_overhaul.config.utils.IAnimConfig;
import elocindev.necronomicon.api.config.v1.NecConfigAPI;
import java.nio.file.Path;

public class ConfigLoader {
    public static boolean checkOutdated(Object[] configs) {
        for (Object config : configs) {
            IAnimConfig aconfig;
            if (!(config instanceof IAnimConfig) || !(aconfig = (IAnimConfig)config).isOutdated()) continue;
            ConfigLoader.updateConfig(aconfig.getFolder(), aconfig.getFileName());
            return true;
        }
        return false;
    }

    public static void reloadConfigs() {
        ConfigLoader.registerConfigs();
        AnimationOverhaul.ANIM_CONFIG = AnimationsConfig.INSTANCE;
        AnimationOverhaul.LOCAL_PLAYER_CONFIG = PlayerConfig.INSTANCE;
        if (AnimationsConfig.INSTANCE.isOutdated()) {
            AnimationOverhaul.LOGGER.warn(String.format("The 'animations' Animation Overhaul config is outdated! It has been updated to the latest version and renamed to animation-old.json5", new Object[0]));
            ConfigLoader.registerConfigs();
        }
        if (PlayerConfig.INSTANCE.isOutdated()) {
            AnimationOverhaul.LOGGER.warn(String.format("The 'local_player' Animation Overhaul config is outdated! It has been updated to the latest version and renamed to local_player-old.json5", new Object[0]));
            ConfigLoader.registerConfigs();
        }
    }

    public static void registerConfigs() {
        NecConfigAPI.registerConfig(AnimationsConfig.class);
        NecConfigAPI.registerConfig(PlayerConfig.class);
    }

    public static void updateConfig(String FOLDER, String FILE_NAME) {
        Path folder = Path.of(NecConfigAPI.getFile((String)FOLDER), new String[0]);
        if (!folder.toFile().exists()) {
            folder.toFile().mkdirs();
        }
        String oldFile = folder.toString() + "/" + FILE_NAME;
        String newFile = folder.toString() + "/" + FILE_NAME + ".old";
        Path oldPath = Path.of(oldFile, new String[0]);
        Path newPath = Path.of(newFile, new String[0]);
        if (oldPath.toFile().exists()) {
            oldPath.toFile().renameTo(newPath.toFile());
        }
    }
}

