/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs;

import com.almostreliable.lootjs.core.AbstractLootModification;
import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.ILootHandler;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.loot.action.AddLootAction;
import com.almostreliable.lootjs.loot.action.CustomPlayerAction;
import com.almostreliable.lootjs.loot.action.GroupedLootAction;
import com.almostreliable.lootjs.loot.action.LootItemFunctionWrapperAction;
import com.almostreliable.lootjs.loot.action.ModifyLootAction;
import com.almostreliable.lootjs.loot.action.RemoveLootAction;
import com.almostreliable.lootjs.loot.action.ReplaceLootAction;
import com.almostreliable.lootjs.loot.action.WeightedAddLootAction;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.mixin.MixinCompositeLootAction;
import com.yanny.ali.mixin.MixinModifyLootAction;
import com.yanny.ali.mixin.MixinRemoveLootAction;
import com.yanny.ali.mixin.MixinReplaceLootAction;
import com.yanny.ali.plugin.lootjs.Utils;
import com.yanny.ali.plugin.lootjs.modifier.CustomPlayerFunction;
import com.yanny.ali.plugin.lootjs.modifier.ModifiedItemFunction;
import com.yanny.ali.plugin.lootjs.node.AddLootNode;
import com.yanny.ali.plugin.lootjs.node.GroupLootNode;
import com.yanny.ali.plugin.lootjs.node.ItemStackNode;
import com.yanny.ali.plugin.lootjs.node.ItemTagNode;
import com.yanny.ali.plugin.lootjs.node.ModifiedNode;
import com.yanny.ali.plugin.lootjs.node.WeightedAddLootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public abstract class LootModifier<T>
implements ILootModifier<T> {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final List<IOperation> operations = new ArrayList<IOperation>();

    public LootModifier(IServerUtils utils, AbstractLootModification byBlock) {
        Collection<ILootHandler> handlers = ((MixinCompositeLootAction)byBlock).getHandlers();
        LinkedList<LootItemCondition> conditions = new LinkedList<LootItemCondition>();
        LinkedList<LootItemFunction> functions = new LinkedList<LootItemFunction>();
        LinkedList<ILootAction> actions = new LinkedList<ILootAction>();
        for (ILootHandler handler : handlers) {
            if (handler instanceof LootItemCondition) {
                LootItemCondition lootItemCondition = (LootItemCondition)handler;
                conditions.add(lootItemCondition);
                continue;
            }
            if (handler instanceof LootItemFunctionWrapperAction) {
                LootItemFunctionWrapperAction lootFunctionAction = (LootItemFunctionWrapperAction)handler;
                functions.add(lootFunctionAction.getLootItemFunction());
                continue;
            }
            if (handler instanceof CustomPlayerAction) {
                CustomPlayerAction customPlayerAction = (CustomPlayerAction)handler;
                functions.add(new CustomPlayerFunction(customPlayerAction));
                continue;
            }
            if (handler instanceof ILootAction) {
                ILootAction lootAction = (ILootAction)handler;
                actions.add(lootAction);
                continue;
            }
            LOGGER.warn("Unhandled handler: {} [{}]", (Object)handler, (Object)handler.getClass().getCanonicalName());
        }
        if (!actions.isEmpty()) {
            for (ILootAction action : actions) {
                Function<IDataNode, List<IDataNode>> factory;
                Object lootAction;
                if (action instanceof AddLootAction) {
                    AddLootAction addLootAction = (AddLootAction)action;
                    this.operations.add(new IOperation.AddOperation(itemStack -> true, new AddLootNode(utils, addLootAction, functions, conditions)));
                    continue;
                }
                if (action instanceof WeightedAddLootAction) {
                    WeightedAddLootAction addLootAction = (WeightedAddLootAction)action;
                    this.operations.add(new IOperation.AddOperation(itemStack -> true, new WeightedAddLootNode(utils, addLootAction, functions, conditions)));
                    continue;
                }
                if (action instanceof GroupedLootAction) {
                    GroupedLootAction groupedLootAction = (GroupedLootAction)action;
                    this.operations.add(new IOperation.AddOperation(itemStack -> true, new GroupLootNode(utils, groupedLootAction, functions, conditions)));
                    continue;
                }
                if (action instanceof RemoveLootAction) {
                    RemoveLootAction removeLootAction = (RemoveLootAction)action;
                    this.operations.add(new IOperation.RemoveOperation(((MixinRemoveLootAction)removeLootAction).getPredicate()));
                    continue;
                }
                if (action instanceof ReplaceLootAction) {
                    ReplaceLootAction replaceLootAction = (ReplaceLootAction)action;
                    lootAction = (MixinReplaceLootAction)replaceLootAction;
                    factory = arg_0 -> LootModifier.lambda$new$3((MixinReplaceLootAction)lootAction, conditions, functions, utils, arg_0);
                    this.operations.add(new IOperation.ReplaceOperation(lootAction.getPredicate(), factory));
                    continue;
                }
                if (action instanceof ModifyLootAction) {
                    ModifyLootAction modifyLootAction = (ModifyLootAction)action;
                    lootAction = (MixinModifyLootAction)modifyLootAction;
                    factory = c -> {
                        if (c instanceof ItemStackNode || c instanceof ItemTagNode || c instanceof ModifiedNode) {
                            return Collections.singletonList(c);
                        }
                        ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                        IItemNode node = (IItemNode)((Object)c);
                        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), node.getConditions().stream()).toList();
                        ArrayList<LootItemFunction> allFunctions = new ArrayList<LootItemFunction>();
                        Either<ItemStack, TagKey<Item>> either = node.getModifiedItem();
                        allFunctions.add(new ModifiedItemFunction());
                        allFunctions.addAll(Stream.concat(functions.stream(), node.getFunctions().stream()).toList());
                        if (!conditions.isEmpty()) {
                            nodes.add(new ModifiedNode(utils, (IDataNode)c, LootModifier.constructEither(utils, either, node.getChance(), allFunctions, allConditions)));
                        } else {
                            nodes.add(LootModifier.constructEither(utils, either, node.getChance(), allFunctions, allConditions));
                        }
                        return nodes;
                    };
                    this.operations.add(new IOperation.ReplaceOperation(lootAction.getPredicate(), factory));
                    continue;
                }
                LOGGER.warn("Skipping unexpected loot action {}", (Object)action.getClass().getCanonicalName());
            }
        } else {
            throw new IllegalStateException("Missing loot action");
        }
    }

    @Override
    public List<IOperation> getOperations() {
        return this.operations;
    }

    private static IDataNode constructEither(IServerUtils utils, Either<ItemStack, TagKey<Item>> either, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return (IDataNode)either.map(itemStack -> new ItemStackNode(utils, (ItemStack)itemStack, chance, true, functions, conditions, true), tagKey -> new ItemTagNode(utils, (TagKey<Item>)tagKey, chance, true, functions, conditions, true));
    }

    private static /* synthetic */ List lambda$new$3(MixinReplaceLootAction lootAction, List conditions, List functions, IServerUtils utils, IDataNode c) {
        if (c instanceof ItemStackNode || c instanceof ItemTagNode || c instanceof ModifiedNode) {
            return Collections.singletonList(c);
        }
        ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
        IItemNode node = (IItemNode)((Object)c);
        LootEntry entry = lootAction.getLootEntry();
        boolean preserveCount = lootAction.getPreserveCount();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), node.getConditions().stream()).toList();
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), node.getFunctions().stream()).toList();
        if (!conditions.isEmpty()) {
            nodes.add(new ModifiedNode(utils, c, Utils.getEntry(utils, entry, 1, allFunctions, allConditions, preserveCount)));
        } else {
            nodes.add(Utils.getEntry(utils, entry, 1, allFunctions, allConditions, preserveCount));
        }
        return nodes;
    }
}

