/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs;

import com.almostreliable.lootjs.core.AbstractLootModification;
import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.LootModificationByBlock;
import com.almostreliable.lootjs.core.LootModificationByEntity;
import com.almostreliable.lootjs.core.LootModificationByTable;
import com.almostreliable.lootjs.core.LootModificationByType;
import com.almostreliable.lootjs.loot.condition.AndCondition;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.AnyDimension;
import com.almostreliable.lootjs.loot.condition.AnyStructure;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import com.almostreliable.lootjs.loot.condition.ContainsLootCondition;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.LootItemConditionWrapper;
import com.almostreliable.lootjs.loot.condition.MainHandTableBonus;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.NotCondition;
import com.almostreliable.lootjs.loot.condition.OrCondition;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.almostreliable.lootjs.loot.condition.WrappedDamageSourceCondition;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.mixin.MixinAbstractLootModification;
import com.yanny.ali.mixin.MixinLootModificationsAPI;
import com.yanny.ali.plugin.lootjs.BlockLootModifier;
import com.yanny.ali.plugin.lootjs.EntityLootModifier;
import com.yanny.ali.plugin.lootjs.TableLootModifier;
import com.yanny.ali.plugin.lootjs.TypeLootModifier;
import com.yanny.ali.plugin.lootjs.modifier.CustomPlayerFunction;
import com.yanny.ali.plugin.lootjs.modifier.ModifiedItemFunction;
import com.yanny.ali.plugin.lootjs.node.AddLootNode;
import com.yanny.ali.plugin.lootjs.node.GroupLootNode;
import com.yanny.ali.plugin.lootjs.node.ItemStackNode;
import com.yanny.ali.plugin.lootjs.node.ItemTagNode;
import com.yanny.ali.plugin.lootjs.node.ModifiedNode;
import com.yanny.ali.plugin.lootjs.node.WeightedAddLootNode;
import com.yanny.ali.plugin.lootjs.server.LootJsConditionTooltipUtils;
import com.yanny.ali.plugin.lootjs.server.LootJsFunctionTooltipUtils;
import com.yanny.ali.plugin.lootjs.widget.AddLootWidget;
import com.yanny.ali.plugin.lootjs.widget.GroupedLootWidget;
import com.yanny.ali.plugin.lootjs.widget.ItemStackWidget;
import com.yanny.ali.plugin.lootjs.widget.ItemTagWidget;
import com.yanny.ali.plugin.lootjs.widget.ModifiedWidget;
import com.yanny.ali.plugin.lootjs.widget.WeightedAddLootWidget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@AliEntrypoint
public class LootJsPlugin
implements IPlugin {
    public static final String ID = "lootjs";
    private static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public static List<ILootModifier<?>> registerModifiers(IServerUtils utils) {
        ArrayList modifiers = new ArrayList();
        List<ILootAction> actions = MixinLootModificationsAPI.getActions();
        for (ILootAction action : actions) {
            if (action instanceof AbstractLootModification) {
                AbstractLootModification lootModification = (AbstractLootModification)action;
                try {
                    if (lootModification instanceof LootModificationByBlock) {
                        LootModificationByBlock byBlock = (LootModificationByBlock)lootModification;
                        modifiers.add(new BlockLootModifier(utils, byBlock));
                        continue;
                    }
                    if (lootModification instanceof LootModificationByEntity) {
                        LootModificationByEntity byEntity = (LootModificationByEntity)lootModification;
                        modifiers.add(new EntityLootModifier(utils, byEntity));
                        continue;
                    }
                    if (lootModification instanceof LootModificationByTable) {
                        LootModificationByTable byTable = (LootModificationByTable)lootModification;
                        modifiers.add(new TableLootModifier(utils, byTable));
                        continue;
                    }
                    if (lootModification instanceof LootModificationByType) {
                        LootModificationByType byType = (LootModificationByType)lootModification;
                        modifiers.add(new TypeLootModifier(utils, byType));
                        continue;
                    }
                    LOGGER.error("Skipping unexpected modification type {}", (Object)lootModification.getClass().getCanonicalName());
                }
                catch (Throwable e) {
                    LOGGER.error("Failed to process loot modification {}: {}", (Object)((MixinAbstractLootModification)lootModification).getName(), (Object)e.getMessage());
                }
                continue;
            }
            LOGGER.error("Unexpected action type {}", (Object)action.getClass().getCanonicalName());
        }
        return modifiers;
    }

    @Override
    public void registerClient(IClientRegistry registry) {
        registry.registerNode(AddLootNode.ID, AddLootNode::new);
        registry.registerNode(WeightedAddLootNode.ID, WeightedAddLootNode::new);
        registry.registerNode(ItemStackNode.ID, ItemStackNode::new);
        registry.registerNode(ItemTagNode.ID, ItemTagNode::new);
        registry.registerNode(GroupLootNode.ID, GroupLootNode::new);
        registry.registerNode(ModifiedNode.ID, ModifiedNode::new);
        registry.registerWidget(AddLootNode.ID, AddLootWidget::new);
        registry.registerWidget(WeightedAddLootNode.ID, WeightedAddLootWidget::new);
        registry.registerWidget(ItemStackNode.ID, ItemStackWidget::new);
        registry.registerWidget(ItemTagNode.ID, ItemTagWidget::new);
        registry.registerWidget(GroupLootNode.ID, GroupedLootWidget::new);
        registry.registerWidget(ModifiedNode.ID, ModifiedWidget::new);
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(AndCondition.class, LootJsConditionTooltipUtils::andConditionTooltip);
        registry.registerConditionTooltip(AnyBiomeCheck.class, LootJsConditionTooltipUtils::anyBiomeCheckTooltip);
        registry.registerConditionTooltip(AnyDimension.class, LootJsConditionTooltipUtils::anyDimensionTooltip);
        registry.registerConditionTooltip(AnyStructure.class, LootJsConditionTooltipUtils::anyStructureTooltip);
        registry.registerConditionTooltip(BiomeCheck.class, LootJsConditionTooltipUtils::biomeCheckTooltip);
        registry.registerConditionTooltip(ContainsLootCondition.class, LootJsConditionTooltipUtils::containsLootConditionTooltip);
        registry.registerConditionTooltip(CustomParamPredicate.class, LootJsConditionTooltipUtils::customParamPredicateTooltip);
        registry.registerConditionTooltip(IsLightLevel.class, LootJsConditionTooltipUtils::isLightLevelTooltip);
        registry.registerConditionTooltip(LootItemConditionWrapper.class, LootJsConditionTooltipUtils::lootItemConditionWrapperTooltip);
        registry.registerConditionTooltip(MainHandTableBonus.class, LootJsConditionTooltipUtils::mainHandTableBonusTooltip);
        registry.registerConditionTooltip(MatchEquipmentSlot.class, LootJsConditionTooltipUtils::getMatchEquipmentSlotTooltip);
        registry.registerConditionTooltip(MatchKillerDistance.class, LootJsConditionTooltipUtils::matchKillerDistanceTooltip);
        registry.registerConditionTooltip(MatchPlayer.class, LootJsConditionTooltipUtils::matchPlayerTooltip);
        registry.registerConditionTooltip(NotCondition.class, LootJsConditionTooltipUtils::notConditionTooltip);
        registry.registerConditionTooltip(OrCondition.class, LootJsConditionTooltipUtils::orConditionTooltip);
        registry.registerConditionTooltip(PlayerParamPredicate.class, LootJsConditionTooltipUtils::playerParamPredicateTooltip);
        registry.registerConditionTooltip(WrappedDamageSourceCondition.class, LootJsConditionTooltipUtils::wrapperDamageSourceConditionTooltip);
        registry.registerFunctionTooltip(CustomPlayerFunction.class, LootJsFunctionTooltipUtils::customPlayerTooltip);
        registry.registerFunctionTooltip(ModifiedItemFunction.class, LootJsFunctionTooltipUtils::modifiedItemTooltip);
        registry.registerLootModifiers(LootJsPlugin::registerModifiers);
    }
}

