/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TextureWidget
extends IWidget {
    protected final ResourceLocation texture;
    protected final RelativeRect rect;
    protected final int u;
    protected final int v;
    protected final int regionWidth;
    protected final int regionHeight;
    protected final int textureWidth;
    protected final int textureHeight;
    private final List<Component> components = new LinkedList<Component>();

    public TextureWidget(ResourceLocation texture, RelativeRect rect, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        super(new ResourceLocation("texture_widget"));
        this.texture = texture;
        this.rect = rect;
        this.u = u;
        this.v = v;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        rect.setDimensions(rect.width, rect.height);
    }

    public TextureWidget(ResourceLocation texture, RelativeRect rect, int u, int v) {
        this(texture, rect, u, v, rect.width, rect.height, 256, 256);
    }

    @Override
    public RelativeRect getRect() {
        return this.rect;
    }

    @Override
    public WidgetDirection getDirection() {
        return WidgetDirection.VERTICAL;
    }

    public void tooltipText(List<ITooltipNode> tooltip) {
        this.components.addAll(NodeUtils.toComponents(tooltip, 0));
    }

    @Override
    public List<Component> getTooltipComponents(int mouseX, int mouseY) {
        return this.components;
    }

    @Override
    public void render(GuiGraphics draw, int mouseX, int mouseY) {
        draw.m_280411_(this.texture, this.rect.getX(), this.rect.getY(), this.rect.width, this.rect.height, (float)this.u, (float)this.v, this.regionWidth, this.regionHeight, this.textureWidth, this.textureHeight);
    }
}

