/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class SyncLootTableMessage {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ResourceLocation location;
    public final List<ItemStack> items;
    public final IDataNode node;

    public SyncLootTableMessage(ResourceLocation location, List<ItemStack> items, IDataNode node) {
        this.location = location;
        this.items = items;
        this.node = node;
    }

    public SyncLootTableMessage(FriendlyByteBuf buf) {
        Object dataNode;
        this.location = buf.m_130281_();
        this.items = buf.m_236845_(FriendlyByteBuf::m_130267_);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            dataNode = utils.getNodeFactory(LootTableNode.ID).create(utils, buf);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to decode node for loot table {} with error: {}", (Object)this.location, (Object)e.getMessage());
            dataNode = new MissingNode();
        }
        this.node = dataNode;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.location);
        buf.m_236828_(this.items, FriendlyByteBuf::m_130055_);
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        try {
            this.node.encode(utils, buf);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to encode node with error: {}", (Object)e.getMessage());
            new MissingNode().encode(utils, buf);
        }
    }

    public static String compressString(String input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(baos);){
            gzipOut.write(input.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.error("Failed to compress loot table with error: {}", (Object)e.getMessage());
            throw new RuntimeException();
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public static String decompressString(String compressedBase64) {
        byte[] compressedBytes = Base64.getDecoder().decode(compressedBase64);
        ByteArrayInputStream bais = new ByteArrayInputStream(compressedBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPInputStream gzipIn = new GZIPInputStream(bais);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gzipIn.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to decompress loot table with error: {}", (Object)e.getMessage());
            throw new RuntimeException();
        }
        return baos.toString(StandardCharsets.UTF_8);
    }
}

