/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.network.AbstractServer;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.Client;
import com.yanny.ali.network.DistHolder;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.Server;
import com.yanny.ali.network.SyncLootTableMessage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    private static int messageId = 0;

    public static DistHolder<AbstractClient, AbstractServer> registerLootInfoPropagator(SimpleChannel channel) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return NetworkUtils.registerClientLootInfoPropagator(channel);
        }
        return NetworkUtils.registerServerLootInfoPropagator(channel);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerClientLootInfoPropagator(SimpleChannel channel) {
        Client client = new Client();
        Server server = new Server(channel);
        channel.registerMessage(NetworkUtils.getMessageId(), SyncLootTableMessage.class, SyncLootTableMessage::encode, SyncLootTableMessage::new, client::onLootInfo);
        channel.registerMessage(NetworkUtils.getMessageId(), ClearMessage.class, ClearMessage::encode, ClearMessage::new, client::onClear);
        channel.registerMessage(NetworkUtils.getMessageId(), DoneMessage.class, DoneMessage::encode, DoneMessage::new, client::onDone);
        return new DistHolder<AbstractClient, AbstractServer>(client, server);
    }

    @NotNull
    private static DistHolder<AbstractClient, AbstractServer> registerServerLootInfoPropagator(SimpleChannel channel) {
        Server server = new Server(channel);
        channel.registerMessage(NetworkUtils.getMessageId(), SyncLootTableMessage.class, SyncLootTableMessage::encode, SyncLootTableMessage::new, (m, c) -> {});
        channel.registerMessage(NetworkUtils.getMessageId(), ClearMessage.class, ClearMessage::encode, ClearMessage::new, (m, c) -> {});
        channel.registerMessage(NetworkUtils.getMessageId(), DoneMessage.class, DoneMessage::encode, DoneMessage::new, (m, c) -> {});
        return new DistHolder<Object, Server>(null, server);
    }

    private static int getMessageId() {
        return ++messageId;
    }
}

