/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.DoneMessage;
import com.yanny.ali.network.SyncLootTableMessage;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<SyncLootTableMessage> messages = new LinkedList<SyncLootTableMessage>();

    public final void readLootTables(LootDataManager manager, ServerLevel level) {
        AliServerRegistry serverRegistry = PluginManager.SERVER_REGISTRY;
        Map<ResourceLocation, LootTable> lootTables = AbstractServer.collectLootTables(manager);
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        HashMap<ResourceLocation, LootTable> unprocessedLootTables = new HashMap<ResourceLocation, LootTable>(lootTables);
        List<ILootModifier<?>> lootModifiers = serverRegistry.getLootModifiers();
        Map<ILootModifier.IType, List<ILootModifier>> groupedTypes = lootModifiers.stream().collect(Collectors.groupingBy(ILootModifier::getType));
        List<ILootModifier<?>> blockLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.BLOCK, Collections.emptyList());
        List<ILootModifier<?>> entityLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.ENTITY, Collections.emptyList());
        List<ILootModifier<?>> lootTableLootModifiers = groupedTypes.getOrDefault(ILootModifier.IType.LOOT_TABLE, Collections.emptyList());
        serverRegistry.setServerLevel(level);
        lootTables.forEach(serverRegistry::addLootTable);
        Map<ResourceLocation, List<Item>> lootTableItems = lootTables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, AbstractServer::getItems));
        this.messages.clear();
        lootNodes.putAll(AbstractServer.processBlocks(serverRegistry, unprocessedLootTables, blockLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processEntities(serverRegistry, level, unprocessedLootTables, entityLootModifiers, lootTableLootModifiers, lootTableItems));
        lootNodes.putAll(AbstractServer.processLootTables(serverRegistry, unprocessedLootTables, lootTableLootModifiers, lootTableItems));
        Map<ResourceLocation, List<ItemStack>> lootTableItemStacks = lootNodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractServer.collectItems((IDataNode)e.getValue())));
        lootTables = AbstractServer.removeEmptyLootTable(lootTables, lootTableItemStacks);
        this.sendLootData(lootTables, lootTableItemStacks, lootNodes);
        LOGGER.info("Prepared {} loot tables", (Object)this.messages.size());
    }

    public final void syncLootTables(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendClearMessage(serverPlayer, new ClearMessage());
            for (SyncLootTableMessage message : this.messages) {
                try {
                    this.sendSyncMessage(serverPlayer, message);
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to send message for loot table {} with error: {}", (Object)message.location, (Object)e.getMessage());
                }
            }
            this.sendDoneMessage(serverPlayer, new DoneMessage());
        }
    }

    protected abstract void sendClearMessage(ServerPlayer var1, ClearMessage var2);

    protected abstract void sendSyncMessage(ServerPlayer var1, SyncLootTableMessage var2);

    protected abstract void sendDoneMessage(ServerPlayer var1, DoneMessage var2);

    @NotNull
    private static List<Item> getItems(Map.Entry<ResourceLocation, LootTable> lootTableMap) {
        return ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, lootTableMap.getValue());
    }

    @NotNull
    private static Map<ResourceLocation, LootTable> removeEmptyLootTable(Map<ResourceLocation, LootTable> lootTables, Map<ResourceLocation, List<ItemStack>> items) {
        HashMap<ResourceLocation, LootTable> result = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<ResourceLocation, LootTable> entry : lootTables.entrySet()) {
            if (!items.getOrDefault(entry.getKey(), Collections.emptyList()).isEmpty()) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            LOGGER.info("Skipping empty loot table {}", (Object)entry.getKey());
        }
        return result;
    }

    @NotNull
    private static Map<ResourceLocation, LootTable> collectLootTables(LootDataManager manager) {
        HashMap<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
        manager.m_278706_(LootDataType.f_278413_).forEach(location -> lootTables.put((ResourceLocation)location, manager.m_278676_(location)));
        return lootTables;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processBlocks(AliServerRegistry serverRegistry, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> blockLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (Block block : BuiltInRegistries.f_256975_) {
            ResourceLocation location = block.m_60589_();
            LootTable lootTable = lootTables.remove(location);
            List<Item> items = lootTableItems.get(location);
            if (lootTable != null) {
                List<ILootModifier<?>> lootModifiers = Stream.concat(blockLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, block, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                continue;
            }
            LOGGER.debug("Missing block loot table for {}", (Object)block);
        }
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processEntities(AliServerRegistry serverRegistry, ServerLevel level, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> entityLootModifiers, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (EntityType entityType : BuiltInRegistries.f_256780_) {
            List<Entity> entityList = serverRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : entityList) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                ResourceLocation location = mob.m_5743_();
                LootTable lootTable = lootTables.remove(location);
                List<Item> items = lootTableItems.get(location);
                if (lootTable != null) {
                    List<ILootModifier<?>> lootModifiers = Stream.concat(entityLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, entity, items)), lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items))).toList();
                    lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
                    continue;
                }
                LOGGER.debug("Missing entity loot table for {}", (Object)entity);
            }
        }
        return lootNodes;
    }

    @NotNull
    private static Map<ResourceLocation, IDataNode> processLootTables(AliServerRegistry serverRegistry, Map<ResourceLocation, LootTable> lootTables, List<ILootModifier<?>> lootTableLootModifiers, Map<ResourceLocation, List<Item>> lootTableItems) {
        HashMap<ResourceLocation, IDataNode> lootNodes = new HashMap<ResourceLocation, IDataNode>();
        for (Map.Entry<ResourceLocation, LootTable> entry : lootTables.entrySet()) {
            ResourceLocation location = entry.getKey();
            LootTable lootTable = entry.getValue();
            List<Item> items = lootTableItems.get(location);
            List<ILootModifier<?>> lootModifiers = lootTableLootModifiers.stream().filter(m -> AbstractServer.predicateModifier(m, location, items)).toList();
            lootNodes.put(location, serverRegistry.parseTable(lootModifiers, lootTable));
        }
        return lootNodes;
    }

    private static <T> boolean predicateModifier(ILootModifier<?> modifier, T value, List<Item> items) {
        return modifier.predicate(value) && AbstractServer.predicateItem(modifier, items);
    }

    private static boolean predicateItem(ILootModifier<?> modifier, List<Item> items) {
        return items.stream().anyMatch(i -> modifier.getOperations().stream().anyMatch(o -> o.predicate().test(i.m_7968_())));
    }

    @NotNull
    private static List<ItemStack> collectItems(IDataNode node) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            for (IDataNode n : listNode.nodes()) {
                itemStacks.addAll(AbstractServer.collectItems(n));
            }
        } else if (node instanceof IItemNode) {
            IItemNode itemNode = (IItemNode)((Object)node);
            itemStacks.addAll((Collection)itemNode.getModifiedItem().map(List::of, AbstractServer::toItemStacks));
        }
        return itemStacks;
    }

    private void sendLootData(Map<ResourceLocation, LootTable> lootTables, Map<ResourceLocation, List<ItemStack>> lootTableItemStacks, Map<ResourceLocation, IDataNode> lootNodes) {
        lootTables.forEach((location, lootTable) -> this.messages.add(new SyncLootTableMessage((ResourceLocation)location, lootTableItemStacks.getOrDefault(location, Collections.emptyList()), (IDataNode)lootNodes.get(location))));
    }

    private static List<ItemStack> toItemStacks(TagKey<Item> tag) {
        return BuiltInRegistries.f_257033_.m_203431_(tag).map(holders -> holders.m_203614_().map(Holder::m_203334_).map(Item::m_7968_).toList()).orElse(Collections.emptyList());
    }
}

