/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliCommonRegistry;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginHolder;
import com.yanny.ali.platform.Services;
import java.util.List;
import org.slf4j.Logger;

public class PluginManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static AliClientRegistry CLIENT_REGISTRY;
    public static AliServerRegistry SERVER_REGISTRY;
    public static AliCommonRegistry COMMON_REGISTRY;
    private static List<PluginHolder> PLUGINS;

    public static void registerClientEvent() {
        PluginManager.registerClientData();
    }

    public static void registerCommonEvent() {
        PLUGINS = Services.getPlatform().getPlugins();
        LOGGER.info("Registering common plugin data...");
        COMMON_REGISTRY = new AliCommonRegistry();
        for (PluginHolder plugin : PLUGINS) {
            try {
                plugin.plugin().registerCommon(COMMON_REGISTRY);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to register {} common part with error: {}", (Object)plugin.modId(), (Object)throwable.getMessage());
            }
        }
        COMMON_REGISTRY.printClientInfo();
        LOGGER.info("Registering common plugin data finished");
    }

    public static void registerServerEvent() {
        PluginManager.registerServerData();
    }

    private static void registerClientData() {
        LOGGER.info("Registering client plugin data...");
        CLIENT_REGISTRY = new AliClientRegistry(COMMON_REGISTRY);
        for (PluginHolder plugin : PLUGINS) {
            try {
                plugin.plugin().registerClient(CLIENT_REGISTRY);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to register {} client part with error: {}", (Object)plugin.modId(), (Object)throwable.getMessage());
            }
        }
        CLIENT_REGISTRY.printClientInfo();
        LOGGER.info("Registering client plugin data finished");
    }

    private static void registerServerData() {
        LOGGER.info("Registering server plugin data...");
        SERVER_REGISTRY = new AliServerRegistry(COMMON_REGISTRY);
        for (PluginHolder plugin : PLUGINS) {
            try {
                plugin.plugin().registerServer(SERVER_REGISTRY);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to register {} server part with error: {}", (Object)plugin.modId(), (Object)throwable.getMessage());
            }
        }
        SERVER_REGISTRY.prepareLootModifiers();
        SERVER_REGISTRY.printServerInfo();
        LOGGER.info("Registering server plugin data finished");
    }
}

