/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBaseLoot;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

public class EmiEntityLoot
extends EmiBaseLoot {
    private final Entity entity;

    public EmiEntityLoot(EmiRecipeCategory category, ResourceLocation id, Entity entity, IDataNode lootTable, List<ItemStack> items) {
        super(category, id, lootTable, 0, 48, items);
        this.entity = entity;
        SpawnEggItem spawnEgg = SpawnEggItem.m_43213_((EntityType)entity.m_6095_());
        if (spawnEgg != null) {
            this.catalysts = List.of(EmiStack.of((ItemLike)spawnEgg));
        }
    }

    public int getDisplayHeight() {
        return 48 + this.getItemsHeight();
    }

    @Override
    protected List<Widget> getAdditionalWidgets(final WidgetHolder widgetHolder) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            int length = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.entity.m_5446_());
            widgets.add(new Widget(){
                private static final int WIDGET_SIZE = 36;
                final Bounds bounds;
                final Rect rect;
                {
                    this.bounds = new Bounds((widgetHolder.getWidth() - 36) / 2, 10, 36, 36);
                    this.rect = new Rect(this.bounds.x(), this.bounds.y(), this.bounds.width(), this.bounds.height());
                }

                public Bounds getBounds() {
                    return this.bounds;
                }

                public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                    GenericUtils.renderEntity(EmiEntityLoot.this.entity, this.rect, widgetHolder.getWidth(), guiGraphics, mouseX, mouseY);
                }
            });
            widgets.add((Widget)new TextWidget(this.entity.m_5446_().m_7532_(), (widgetHolder.getWidth() - length) / 2, 0, 0, false));
        }
        this.catalysts.forEach(catalyst -> widgets.add((Widget)new SlotWidget(catalyst, 0, 0)));
        return widgets;
    }
}

