/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.emi.EmiLootSlotWidget;
import com.yanny.ali.compatibility.emi.EmiScrollWidget;
import com.yanny.ali.compatibility.emi.EmiWidgetWrapper;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;

public abstract class EmiBaseLoot
extends BasicEmiRecipe {
    static final int CATEGORY_WIDTH = 162 - EmiScrollWidget.getScrollBoxScrollbarExtraWidth();
    private final Widget widget;
    private final List<Holder> slotWidgets = new LinkedList<Holder>();

    public EmiBaseLoot(EmiRecipeCategory category, ResourceLocation id, IDataNode lootTable, int widgetX, int widgetY, List<ItemStack> items) {
        super(category, id, CATEGORY_WIDTH + EmiScrollWidget.getScrollBoxScrollbarExtraWidth(), 1024);
        RelativeRect rect = new RelativeRect(widgetX, widgetY, CATEGORY_WIDTH, 0);
        this.widget = new EmiWidgetWrapper(new LootTableWidget(this.getEmiUtils((EmiRecipe)this), lootTable, rect, CATEGORY_WIDTH));
        this.outputs.addAll(items.stream().map(EmiStack::of).toList());
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        Rect rect = new Rect(0, 0, CATEGORY_WIDTH + EmiScrollWidget.getScrollBoxScrollbarExtraWidth(), Math.min(this.getDisplayHeight(), widgetHolder.getHeight()));
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.addAll(this.slotWidgets.stream().map(h -> {
            EmiIngredient ingredient = (EmiIngredient)h.item.map(EmiStack::of, EmiIngredient::of);
            EmiLootSlotWidget widget = new EmiLootSlotWidget(h.utils, h.entry, ingredient, h.rect.getX(), h.rect.getY(), ((IItemNode)((Object)h.entry)).getCount());
            widget.recipeContext(h.recipe);
            return widget;
        }).toList());
        widgets.addAll(this.getAdditionalWidgets(widgetHolder));
        widgets.add(this.widget);
        widgetHolder.add((Widget)new EmiScrollWidget(rect, this.getDisplayHeight(), widgets));
    }

    public Recipe<?> getBackingRecipe() {
        return null;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    protected int getItemsHeight() {
        return this.widget.getBounds().height();
    }

    protected List<Widget> getAdditionalWidgets(WidgetHolder widgetHolder) {
        return List.of();
    }

    @NotNull
    private IWidgetUtils getEmiUtils(final EmiRecipe recipe) {
        return new ClientUtils(){

            @Override
            public void addSlotWidget(Either<ItemStack, TagKey<Item>> item, IDataNode entry, RelativeRect rect) {
                EmiBaseLoot.this.slotWidgets.add(new Holder(this, item, entry, rect, recipe));
            }
        };
    }

    private record Holder(IWidgetUtils utils, Either<ItemStack, TagKey<Item>> item, IDataNode entry, RelativeRect rect, EmiRecipe recipe) {
    }
}

