/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.Utils;
import com.yanny.ali.api.Rect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.m_91087_().f_91062_.m_92895_("...");

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        PoseStack poseStack = guiGraphics.m_280168_();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.m_85445_());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.m_85446_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280411_(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.m_280588_(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            EntityDimensions dimensions = entity.m_6095_().m_20680_();
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(bounds.x() + bounds.width() / 2), (int)(bounds.y() + 36 - 5), (int)((int)Math.min(20.0f / dimensions.f_20378_, 20.0f / dimensions.f_20377_)), (float)((float)(-mouseX) + (float)fullWidth / 2.0f), (float)((float)(-mouseY) + 18.0f), (LivingEntity)livingEntity);
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        text = Language.m_128107_().m_118919_(text, fallback);
        if (font.m_92895_(text) > maxWidth) {
            int index = 20;
            while (font.m_92895_(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.m_237113_((String)(text.substring(0, index) + "..."));
        }
        return Component.m_237113_((String)text);
    }
}

