/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Holder<ReiBlockDisplay, BlockLootType, Block>> blockCategoryList = new LinkedList<Holder<ReiBlockDisplay, BlockLootType, Block>>();
    private final List<Holder<ReiEntityDisplay, EntityLootType, Entity>> entityCategoryList = new LinkedList<Holder<ReiEntityDisplay, EntityLootType, Entity>>();
    private final List<Holder<ReiGameplayDisplay, GameplayLootType, String>> gameplayCategoryList = new LinkedList<Holder<ReiGameplayDisplay, GameplayLootType, String>>();

    public void registerCategories(CategoryRegistry registry) {
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.blockCategoryList.add(this.createCategory(LootCategories.PLANT_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiBlockDisplay::new, ReiBlockCategory::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(this.createCategory(LootCategories.BLOCK_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiEntityDisplay::new, ReiEntityCategory::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(this.createCategory(LootCategories.ENTITY_LOOT, ReiEntityDisplay::new, ReiEntityCategory::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiGameplayDisplay::new, ReiGameplayCategory::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(this.createCategory(LootCategories.GAMEPLAY_LOOT, ReiGameplayDisplay::new, ReiGameplayCategory::new));
        for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategoryList) {
            registry.add(holder.category);
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener(lootData -> this.registerLootData(registry, lootData));
    }

    private void registerLootData(DisplayRegistry registry, Map<ResourceLocation, IDataNode> lootData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LOGGER.info("Adding loot information to REI");
        if (level != null) {
            ResourceLocation location;
            HashMap<Holder, List> blockRecipeTypes = new HashMap<Holder, List>();
            HashMap<Holder, List> entityRecipeTypes = new HashMap<Holder, List>();
            HashMap<Holder, List> gameplayRecipeTypes = new HashMap<Holder, List>();
            for (Block block : BuiltInRegistries.f_256975_) {
                location = block.m_60589_();
                IDataNode node = lootData.get(location);
                if (node == null) continue;
                for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategoryList) {
                    if (!holder.category.getLootCategory().validate(block)) continue;
                    blockRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new BlockLootType(block, node, clientRegistry.getItems(location)));
                    break;
                }
                lootData.remove(location);
            }
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                List<Entity> entityList = clientRegistry.createEntities(entityType, (Level)level);
                for (Entity entity : entityList) {
                    Mob mob;
                    ResourceLocation location2;
                    IDataNode node;
                    if (!(entity instanceof Mob) || (node = lootData.get(location2 = (mob = (Mob)entity).m_5743_())) == null) continue;
                    for (Holder<ReiEntityDisplay, EntityLootType, Entity> holder : this.entityCategoryList) {
                        if (!holder.category.getLootCategory().validate(entity)) continue;
                        entityRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new EntityLootType(entity, node, clientRegistry.getItems(location2)));
                        break;
                    }
                    lootData.remove(location2);
                }
            }
            for (Map.Entry<ResourceLocation, IDataNode> entry : new HashMap<ResourceLocation, IDataNode>(lootData).entrySet()) {
                location = entry.getKey();
                for (Holder holder : this.gameplayCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.m_135815_())) continue;
                    gameplayRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new GameplayLootType(entry.getValue(), "/" + location.m_135815_(), clientRegistry.getItems(location)));
                    break;
                }
                lootData.remove(location);
            }
            for (Map.Entry<Object, IDataNode> entry : blockRecipeTypes.entrySet()) {
                registry.registerFiller(this.blockPredicate((List)((Object)entry.getValue())), ((Holder)entry.getKey()).filler());
                ((List)((Object)entry.getValue())).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry<Object, IDataNode> entry : entityRecipeTypes.entrySet()) {
                registry.registerFiller(this.entityPredicate((List)((Object)entry.getValue())), ((Holder)entry.getKey()).filler());
                ((List)((Object)entry.getValue())).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry<Object, IDataNode> entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFiller(this.gameplayPredicate((List)((Object)entry.getValue())), ((Holder)entry.getKey()).filler());
                ((List)((Object)entry.getValue())).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        }
        if (!me.shedaniel.rei.api.common.plugins.PluginManager.getClientInstance().isReloading()) {
            LOGGER.info("Loot information was added too late, requesting reload REI");
            me.shedaniel.rei.api.common.plugins.PluginManager.getClientInstance().startReload();
        }
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(Map.Entry<ResourceLocation, LootCategory<U>> e, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        ResourceLocation id = e.getKey();
        CategoryIdentifier identifier = CategoryIdentifier.of((String)id.m_135827_(), (String)id.m_135815_());
        MutableComponent title = Component.m_237115_((String)("emi.category." + id.m_135827_() + "." + id.m_135815_().replace('/', '.')));
        Function<Object, ReiBaseDisplay> filler = type -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, e.getValue()), filler);
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((String)"ali", (String)lootCategory.getKey());
        MutableComponent title = Component.m_237115_((String)("emi.category.ali." + lootCategory.getKey().replace('/', '.')));
        Function<Object, ReiBaseDisplay> filler = type -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private Predicate<Object> blockPredicate(List<BlockLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private Predicate<Object> entityPredicate(List<EntityLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private Predicate<Object> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, Function<T, D> filler) {
    }
}

