/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.jei.JeiBlockLoot;
import com.yanny.ali.compatibility.jei.JeiEntityLoot;
import com.yanny.ali.compatibility.jei.JeiGameplayLoot;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@JeiPlugin
public class JeiCompatibility
implements IModPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<JeiBlockLoot> blockCategoryList = new LinkedList<JeiBlockLoot>();
    private final List<JeiEntityLoot> entityCategoryList = new LinkedList<JeiEntityLoot>();
    private final List<JeiGameplayLoot> gameplayCategoryList = new LinkedList<JeiGameplayLoot>();

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.blockCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.PLANT_LOOT, BlockLootType.class, JeiBlockLoot::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, BlockLootType.class, JeiBlockLoot::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.BLOCK_LOOT, BlockLootType.class, JeiBlockLoot::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, EntityLootType.class, JeiEntityLoot::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.ENTITY_LOOT, EntityLootType.class, JeiEntityLoot::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, GameplayLootType.class, JeiGameplayLoot::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.GAMEPLAY_LOOT, GameplayLootType.class, JeiGameplayLoot::new));
        this.blockCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.entityCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.gameplayCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener(lootData -> this.registerLootData(registration, lootData));
    }

    private void registerLootData(IRecipeRegistration registration, Map<ResourceLocation, IDataNode> lootData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LOGGER.info("Adding loot information to JEI");
        if (level != null) {
            ResourceLocation location;
            HashMap<RecipeType, List> blockRecipeTypes = new HashMap<RecipeType, List>();
            HashMap<RecipeType, List> entityRecipeTypes = new HashMap<RecipeType, List>();
            HashMap<RecipeType, List> gameplayRecipeTypes = new HashMap<RecipeType, List>();
            for (Block block : BuiltInRegistries.f_256975_) {
                location = block.m_60589_();
                IDataNode lootEntry = lootData.get(location);
                if (lootEntry == null) continue;
                RecipeType recipeType = null;
                for (JeiBlockLoot recipeCategory : this.blockCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(block)) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    blockRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new BlockLootType(block, lootEntry, clientRegistry.getItems(location)));
                }
                lootData.remove(location);
            }
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                List<Entity> entityList = clientRegistry.createEntities(entityType, (Level)level);
                for (Entity entity : entityList) {
                    Mob mob;
                    ResourceLocation location2;
                    IDataNode lootEntry;
                    if (!(entity instanceof Mob) || (lootEntry = lootData.get(location2 = (mob = (Mob)entity).m_5743_())) == null) continue;
                    RecipeType recipeType = null;
                    for (JeiEntityLoot recipeCategory : this.entityCategoryList) {
                        if (!recipeCategory.getLootCategory().validate(entity)) continue;
                        recipeType = recipeCategory.getRecipeType();
                        break;
                    }
                    if (recipeType != null) {
                        entityRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new EntityLootType(entity, lootEntry, clientRegistry.getItems(location2)));
                    }
                    lootData.remove(location2);
                }
            }
            for (Map.Entry<ResourceLocation, IDataNode> entry : lootData.entrySet()) {
                location = entry.getKey();
                RecipeType recipeType = null;
                for (JeiGameplayLoot recipeCategory : this.gameplayCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(location.m_135815_())) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType == null) continue;
                gameplayRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new GameplayLootType(entry.getValue(), "/" + location.m_135815_(), clientRegistry.getItems(location)));
            }
            for (Map.Entry<Object, IDataNode> entry : blockRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), (List)((Object)entry.getValue()));
            }
            for (Map.Entry<Object, IDataNode> entry : entityRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), (List)((Object)entry.getValue()));
            }
            for (Map.Entry<Object, IDataNode> entry : gameplayRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), (List)((Object)entry.getValue()));
            }
        } else {
            LOGGER.warn("JEI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return Utils.modLoc("jei_plugin");
    }

    private static <T, U, V> T createCategory(IGuiHelper guiHelper, LootCategory<U> e, Class<V> clazz, LootConstructor<T, U, V> constructor) {
        RecipeType recipeType = RecipeType.create((String)"ali", (String)e.getKey(), clazz);
        MutableComponent title = Component.m_237115_((String)("emi.category.ali." + e.getKey().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e, (Component)title, guiHelper.createDrawableItemStack(e.getIcon()));
    }

    private static <T, U, V> T createCategory(IGuiHelper guiHelper, Map.Entry<ResourceLocation, LootCategory<U>> e, Class<V> clazz, LootConstructor<T, U, V> constructor) {
        ResourceLocation id = e.getKey();
        RecipeType recipeType = RecipeType.create((String)id.m_135827_(), (String)id.m_135815_(), clazz);
        MutableComponent title = Component.m_237115_((String)("emi.category." + id.m_135827_() + "." + id.m_135815_().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e.getValue(), (Component)title, guiHelper.createDrawableItemStack(e.getValue().getIcon()));
    }

    @FunctionalInterface
    private static interface LootConstructor<T, U, V> {
        public T construct(IGuiHelper var1, RecipeType<V> var2, LootCategory<U> var3, Component var4, IDrawable var5);
    }
}

