/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiReloadManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void register(EmiRegistry emiRegistry) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener(lootData -> this.registerLootData(emiRegistry, lootData));
    }

    private void registerLootData(EmiRegistry registry, Map<ResourceLocation, IDataNode> lootData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LOGGER.info("Adding loot information to EMI");
        if (level != null) {
            ResourceLocation location;
            Map<LootCategory, EmiRecipeCategory> blockCategoryMap = LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> entityCategoryMap = LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> gameplayCategoryMap = LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            blockCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            EmiRecipeCategory blockCategory = EmiCompatibility.createCategory(LootCategories.BLOCK_LOOT);
            EmiRecipeCategory plantCategory = EmiCompatibility.createCategory(LootCategories.PLANT_LOOT);
            EmiRecipeCategory entityCategory = EmiCompatibility.createCategory(LootCategories.ENTITY_LOOT);
            EmiRecipeCategory gameplayCategory = EmiCompatibility.createCategory(LootCategories.GAMEPLAY_LOOT);
            registry.addCategory(blockCategory);
            registry.addCategory(plantCategory);
            registry.addCategory(entityCategory);
            registry.addCategory(gameplayCategory);
            for (Block block : BuiltInRegistries.f_256975_) {
                location = block.m_60589_();
                IDataNode lootEntry = lootData.get(location);
                if (lootEntry == null) continue;
                EmiRecipeCategory category = null;
                if (LootCategories.PLANT_LOOT.validate(block)) {
                    category = plantCategory;
                } else {
                    for (Map.Entry<LootCategory, EmiRecipeCategory> entry : blockCategoryMap.entrySet()) {
                        if (!entry.getKey().validate(block)) continue;
                        category = entry.getValue();
                    }
                    if (category == null) {
                        category = blockCategory;
                    }
                }
                registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, new ResourceLocation(location.m_135827_(), "/" + location.m_135815_()), block, lootEntry, clientRegistry.getItems(location)));
                lootData.remove(location);
            }
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                List<Entity> entityList = clientRegistry.createEntities(entityType, (Level)level);
                entityList.forEach(entity -> {
                    Mob mob;
                    ResourceLocation location;
                    IDataNode lootEntry;
                    if (entity instanceof Mob && (lootEntry = (IDataNode)lootData.get(location = (mob = (Mob)entity).m_5743_())) != null) {
                        EmiRecipeCategory category = null;
                        for (Map.Entry entry : entityCategoryMap.entrySet()) {
                            if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                            category = (EmiRecipeCategory)entry.getValue();
                        }
                        if (category == null) {
                            category = entityCategory;
                        }
                        registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, new ResourceLocation(location.m_135827_(), "/" + location.m_135815_()), (Entity)entity, lootEntry, clientRegistry.getItems(location)));
                        lootData.remove(location);
                    }
                });
            }
            for (Map.Entry<ResourceLocation, IDataNode> entry : lootData.entrySet()) {
                location = entry.getKey();
                EmiRecipeCategory category = null;
                for (Map.Entry<LootCategory, EmiRecipeCategory> gameplayEntry : gameplayCategoryMap.entrySet()) {
                    if (!gameplayEntry.getKey().validate(location.m_135815_())) continue;
                    category = gameplayEntry.getValue();
                }
                if (category == null) {
                    category = gameplayCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, new ResourceLocation(location.m_135827_(), "/" + location.m_135815_()), entry.getValue(), clientRegistry.getItems(location)));
            }
        }
        if (EmiReloadManager.isLoaded()) {
            LOGGER.info("Loot information was added too late, requesting reload EMI");
            EmiReloadManager.reload();
        }
    }

    @NotNull
    private static EmiRecipeCategory createCategory(LootCategory<?> category) {
        return new EmiRecipeCategory(Utils.modLoc(category.getKey()), (EmiRenderable)EmiStack.of((ItemStack)category.getIcon()));
    }
}

