/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class ListWidget
extends IWidget {
    public static final ResourceLocation TEXTURE_LOC = new ResourceLocation("ali", "textures/gui/gui.png");
    public static final int GROUP_WIDGET_WIDTH = 7;
    public static final int GROUP_WIDGET_HEIGHT = 18;
    private final List<IWidget> widgets;
    private final RelativeRect bounds;

    public ListWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        this(utils, entry, rect, maxWidth, entry);
    }

    public ListWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth, IDataNode tooltipNode) {
        super(entry.getId());
        IWidget groupWidget = this.getLootGroupWidget(rect, tooltipNode);
        boolean hasGroupWidget = groupWidget != null;
        int xOffset = hasGroupWidget ? 7 : 0;
        this.widgets = new ArrayList<IWidget>();
        this.bounds = rect;
        if (hasGroupWidget) {
            this.widgets.add(groupWidget);
        }
        if (entry instanceof ListNode) {
            ListNode listNode = (ListNode)entry;
            RelativeRect subRect = new RelativeRect(xOffset, 0, rect.width - 7, 0, rect);
            this.widgets.addAll(utils.createWidgets(utils, listNode.nodes(), subRect, maxWidth));
            this.bounds.setDimensions(subRect.width + 7, subRect.height);
        } else {
            this.bounds.setDimensions(7, 18);
        }
    }

    @Nullable
    public abstract IWidget getLootGroupWidget(RelativeRect var1, IDataNode var2);

    @Override
    public RelativeRect getRect() {
        return this.bounds;
    }

    @Override
    public WidgetDirection getDirection() {
        return WidgetDirection.VERTICAL;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        WidgetDirection lastDirection = null;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            WidgetDirection direction = widget.getDirection();
            if (direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) {
                lastY = Math.max(lastY, widget.getRect().getY());
            }
            lastDirection = direction;
        }
        int top = this.bounds.getY() + 18;
        int height = lastY - this.bounds.getY() - 9;
        guiGraphics.m_280543_(TEXTURE_LOC, this.bounds.getX() + 3, top, 2, height, 0, 0, 2, 18);
        lastDirection = null;
        for (IWidget widget : this.widgets) {
            WidgetDirection direction = widget.getDirection();
            if ((direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) && widget.getRect().offsetY > 0) {
                guiGraphics.m_280543_(TEXTURE_LOC, this.bounds.getX() + 4, widget.getRect().getY() + 8, 3, 2, 2, 0, 18, 2);
            }
            lastDirection = direction;
        }
    }

    @Override
    public List<Component> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<Component> components = new LinkedList<Component>();
        for (IWidget widget : this.widgets) {
            RelativeRect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            RelativeRect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }
}

