/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvRow;

final class RowHandler {
    private int len;
    private String[] row;
    private int idx;
    private int lines = 1;
    private boolean commentMode;
    private long originalLineNumber = 1L;

    RowHandler(int len) {
        this.len = len;
        this.row = new String[len];
    }

    void add(String value) {
        if (this.idx == this.len) {
            this.extendCapacity();
        }
        this.row[this.idx++] = value;
    }

    private void extendCapacity() {
        this.len *= 2;
        String[] newRow = new String[this.len];
        System.arraycopy(this.row, 0, newRow, 0, this.idx);
        this.row = newRow;
    }

    CsvRow buildAndReset() {
        CsvRow csvRow = this.idx > 0 ? this.build() : null;
        this.idx = 0;
        this.originalLineNumber += (long)this.lines;
        this.lines = 1;
        this.commentMode = false;
        return csvRow;
    }

    private CsvRow build() {
        if (this.idx > 1 || !this.row[0].isEmpty()) {
            String[] ret = new String[this.idx];
            System.arraycopy(this.row, 0, ret, 0, this.idx);
            return new CsvRow(this.originalLineNumber, ret, this.commentMode);
        }
        return new CsvRow(this.originalLineNumber, this.commentMode);
    }

    public void enableCommentMode() {
        this.commentMode = true;
    }

    public boolean isCommentMode() {
        return this.commentMode;
    }

    public void incLines() {
        ++this.lines;
    }
}

