/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.EntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.EntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.StopTriggeredEntityAnimPacket;

public interface GeoEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((class_1297)this).method_5628()).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        class_1297 entity = (class_1297)this;
        if (entity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.sendToTrackingEntityAndSelf(new EntityAnimDataSyncPacket<D>(entity.method_5628(), dataTicket, data), entity);
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        class_1297 entity = (class_1297)this;
        if (entity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.sendToTrackingEntityAndSelf(new EntityAnimTriggerPacket(entity.method_5628(), controllerName, animName), entity);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnimation(@Nullable String controllerName, @Nullable String animName) {
        class_1297 entity = (class_1297)this;
        if (entity.method_37908().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(entity.method_5628());
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibNetwork.sendToTrackingEntityAndSelf(new StopTriggeredEntityAnimPacket(entity.method_5628(), controllerName, animName), entity);
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((class_1297)entity).field_6012;
    }
}

