/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.vmlib.LuaLibrary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ScriptManager
extends class_4080<List<Map.Entry<String, Supplier<LuaTable>>>>
implements IdentifiableResourceReloadListener {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"ScriptLoader");
    private Globals globals;
    private final Map<String, LuaTable> scriptMap = Maps.newHashMap();
    private final class_7654 filetoidconverter;
    private final List<LuaLibrary> libraries;
    public static final class_2960 ID = new class_2960("tacz", "script_manager");

    public ScriptManager(class_7654 converter, List<LuaLibrary> libraries) {
        this.filetoidconverter = converter;
        this.libraries = libraries;
    }

    @NotNull
    protected List<Map.Entry<String, Supplier<LuaTable>>> prepare(class_3300 pResourceManager, class_3695 pProfiler) {
        this.initGlobals();
        ArrayList<Map.Entry<String, Supplier<LuaTable>>> output = new ArrayList<Map.Entry<String, Supplier<LuaTable>>>();
        for (Map.Entry entry : this.filetoidconverter.method_45113(pResourceManager).entrySet()) {
            final Map.Entry<String, Supplier<LuaTable>> wrappedEntry = this.wrapLoadingFunction((class_2960)entry.getKey(), (class_3298)entry.getValue());
            output.add(wrappedEntry);
            this.globals.get("package").get("preload").set(wrappedEntry.getKey(), (LuaValue)new LuaFunction(){

                public LuaValue call(LuaValue modname, LuaValue env) {
                    return (LuaValue)((Supplier)wrappedEntry.getValue()).get();
                }
            });
        }
        return output;
    }

    protected void apply(List<Map.Entry<String, Supplier<LuaTable>>> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        this.scriptMap.clear();
        pObject.forEach(entry -> this.scriptMap.put((String)entry.getKey(), (LuaTable)((Supplier)entry.getValue()).get()));
    }

    private Map.Entry<String, Supplier<LuaTable>> wrapLoadingFunction(class_2960 rawResourceLocation, final class_3298 resource) {
        final class_2960 resourceLocation = this.filetoidconverter.method_45115(rawResourceLocation);
        final String moduleName = this.getModuleName(resourceLocation);
        return new AbstractMap.SimpleEntry<String, Supplier<LuaTable>>(moduleName, new Supplier<LuaTable>(){
            private LuaTable loaded = null;

            @Override
            public LuaTable get() {
                LuaTable luaTable;
                block9: {
                    if (this.loaded != null) {
                        return this.loaded;
                    }
                    BufferedReader reader = resource.method_43039();
                    try {
                        LuaValue chunk = ScriptManager.this.globals.load((Reader)reader, moduleName);
                        luaTable = this.loaded = chunk.call().checktable(1);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonParseException | IOException | IllegalArgumentException | LuaError jsonparseexception) {
                            GunMod.LOGGER.warn(MARKER, "Failed to read script file: {}", (Object)resourceLocation);
                            return null;
                        }
                    }
                    ((Reader)reader).close();
                }
                return luaTable;
            }
        });
    }

    private void initGlobals() {
        this.globals = ScriptManager.secureStandardGlobals();
        if (this.libraries != null) {
            this.libraries.forEach(library -> library.install((LuaValue)this.globals));
        }
    }

    private String getModuleName(class_2960 resourceLocation) {
        return resourceLocation.method_12836() + "_" + resourceLocation.method_12832();
    }

    public LuaTable getScript(class_2960 id) {
        return this.scriptMap.get(this.getModuleName(id));
    }

    private static Globals secureStandardGlobals() {
        Globals globals = new Globals();
        globals.load((LuaValue)new JseBaseLib());
        globals.load((LuaValue)new PackageLib());
        globals.load((LuaValue)new Bit32Lib());
        globals.load((LuaValue)new TableLib());
        globals.load((LuaValue)new JseStringLib());
        globals.load((LuaValue)new JseMathLib());
        LoadState.install((Globals)globals);
        LuaC.install((Globals)globals);
        return globals;
    }

    public class_2960 getFabricId() {
        return ID;
    }
}

