/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.Arrays;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private int[] match;
    private InstructionHandle[] targets;
    private final Select instruction;
    private final int matchLength;

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        this(match, targets, target, 1);
    }

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target, int maxGap) {
        this.match = (int[])match.clone();
        this.targets = (InstructionHandle[])targets.clone();
        this.matchLength = match.length;
        if (this.matchLength < 2) {
            this.instruction = new TABLESWITCH(match, targets, target);
        } else {
            this.sort(0, this.matchLength - 1);
            if (this.matchIsOrdered(maxGap)) {
                this.fillup(maxGap, target);
                this.instruction = new TABLESWITCH(this.match, this.targets, target);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, target);
            }
        }
    }

    private void fillup(int maxGap, InstructionHandle target) {
        int maxSize = this.matchLength + this.matchLength * maxGap;
        int[] mVec = new int[maxSize];
        InstructionHandle[] tVec = new InstructionHandle[maxSize];
        int count = 1;
        mVec[0] = this.match[0];
        tVec[0] = this.targets[0];
        for (int i = 1; i < this.matchLength; ++i) {
            int prev = this.match[i - 1];
            int gap = this.match[i] - prev;
            for (int j = 1; j < gap; ++j) {
                mVec[count] = prev + j;
                tVec[count] = target;
                ++count;
            }
            mVec[count] = this.match[i];
            tVec[count] = this.targets[i];
            ++count;
        }
        this.match = Arrays.copyOf(mVec, count);
        this.targets = Arrays.copyOf(tVec, count);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    public InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    private boolean matchIsOrdered(int maxGap) {
        for (int i = 1; i < this.matchLength; ++i) {
            if (this.match[i] - this.match[i - 1] <= maxGap) continue;
            return false;
        }
        return true;
    }

    private void sort(int l, int r) {
        int i = l;
        int j = r;
        int m4 = this.match[l + r >>> 1];
        while (true) {
            if (this.match[i] < m4) {
                ++i;
                continue;
            }
            while (m4 < this.match[j]) {
                --j;
            }
            if (i <= j) {
                int h2 = this.match[i];
                this.match[i] = this.match[j];
                this.match[j] = h2;
                InstructionHandle h22 = this.targets[i];
                this.targets[i] = this.targets[j];
                this.targets[j] = h22;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.sort(l, j);
        }
        if (i < r) {
            this.sort(i, r);
        }
    }
}

