/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class FillNearestOperation {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    public static void fillNearest() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            FillNearestOperation.fillNearestAABB(aabb);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            FillNearestOperation.fillNearestSet(set);
        }
    }

    private static void fillNearestAABB(SelectionBuffer.AABB aabb) {
        PropagateDataBlock minPropagateDataBlock;
        class_2680 minBlock;
        PropagateDataBlock maxPropagateDataBlock;
        class_2680 maxBlock;
        int z2;
        int x2;
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600() - 1, maxY);
        Position2ObjectMap<PropagateData> propagateDataMap = new Position2ObjectMap<PropagateData>(k -> new PropagateData[4096]);
        LongArrayFIFOQueue propagateQueue = new LongArrayFIFOQueue();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (x2 = minX; x2 <= maxX; ++x2) {
            for (z2 = minZ; z2 <= maxZ; ++z2) {
                maxBlock = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, maxY + 1, z2));
                if (!maxBlock.method_26215()) {
                    maxPropagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)x2, (int)(maxY + 1), (int)z2), maxBlock);
                    FillNearestOperation.initialPropagateTo((class_1937)world, x2, maxY, z2, mutableBlockPos, propagateDataMap, propagateQueue, maxPropagateDataBlock);
                }
                if ((minBlock = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, minY - 1, z2))).method_26215()) continue;
                minPropagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)x2, (int)(minY - 1), (int)z2), minBlock);
                FillNearestOperation.initialPropagateTo((class_1937)world, x2, minY, z2, mutableBlockPos, propagateDataMap, propagateQueue, minPropagateDataBlock);
            }
        }
        for (x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                maxBlock = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2, maxZ + 1));
                if (!maxBlock.method_26215()) {
                    maxPropagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)x2, (int)y2, (int)(maxZ + 1)), maxBlock);
                    FillNearestOperation.initialPropagateTo((class_1937)world, x2, y2, maxZ, mutableBlockPos, propagateDataMap, propagateQueue, maxPropagateDataBlock);
                }
                if ((minBlock = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2, minZ - 1))).method_26215()) continue;
                minPropagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)x2, (int)y2, (int)(minZ - 1)), minBlock);
                FillNearestOperation.initialPropagateTo((class_1937)world, x2, y2, minZ, mutableBlockPos, propagateDataMap, propagateQueue, minPropagateDataBlock);
            }
        }
        for (int y3 = minY; y3 <= maxY; ++y3) {
            for (z2 = minZ; z2 <= maxZ; ++z2) {
                maxBlock = world.method_8320((class_2338)mutableBlockPos.method_10103(maxX + 1, y3, z2));
                if (!maxBlock.method_26215()) {
                    maxPropagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)(maxX + 1), (int)y3, (int)z2), maxBlock);
                    FillNearestOperation.initialPropagateTo((class_1937)world, maxX, y3, z2, mutableBlockPos, propagateDataMap, propagateQueue, maxPropagateDataBlock);
                }
                if ((minBlock = world.method_8320((class_2338)mutableBlockPos.method_10103(minX - 1, y3, z2))).method_26215()) continue;
                minPropagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)(minX - 1), (int)y3, (int)z2), minBlock);
                FillNearestOperation.initialPropagateTo((class_1937)world, minX, y3, z2, mutableBlockPos, propagateDataMap, propagateQueue, minPropagateDataBlock);
            }
        }
        for (x2 = minX; x2 <= maxX; ++x2) {
            for (z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y4 = minY; y4 <= maxY; ++y4) {
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, y4, z2));
                    if (block.method_26215()) continue;
                    PropagateDataBlock propagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)x2, (int)y4, (int)z2), block);
                    propagateDataMap.put(x2, y4, z2, new PropagateData(0, null));
                    if (x2 < maxX) {
                        FillNearestOperation.initialPropagateTo((class_1937)world, x2 + 1, y4, z2, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                    }
                    if (x2 > minX) {
                        FillNearestOperation.initialPropagateTo((class_1937)world, x2 - 1, y4, z2, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                    }
                    if (y4 < maxY) {
                        FillNearestOperation.initialPropagateTo((class_1937)world, x2, y4 + 1, z2, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                    }
                    if (y4 > minY) {
                        FillNearestOperation.initialPropagateTo((class_1937)world, x2, y4 - 1, z2, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                    }
                    if (z2 < maxZ) {
                        FillNearestOperation.initialPropagateTo((class_1937)world, x2, y4, z2 + 1, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                    }
                    if (z2 <= minZ) continue;
                    FillNearestOperation.initialPropagateTo((class_1937)world, x2, y4, z2 - 1, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
            }
        }
        while (!propagateQueue.isEmpty()) {
            long pos = propagateQueue.dequeueLong();
            int x3 = class_2338.method_10061((long)pos);
            int y5 = class_2338.method_10071((long)pos);
            int z3 = class_2338.method_10083((long)pos);
            PropagateData propagateData = (PropagateData)propagateDataMap.get(x3, y5, z3);
            propagateData.queued = false;
            if (x3 < maxX) {
                FillNearestOperation.propagateTo(x3 + 1, y5, z3, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (x3 > minX) {
                FillNearestOperation.propagateTo(x3 - 1, y5, z3, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (y5 < maxY) {
                FillNearestOperation.propagateTo(x3, y5 + 1, z3, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (y5 > minY) {
                FillNearestOperation.propagateTo(x3, y5 - 1, z3, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (z3 < maxZ) {
                FillNearestOperation.propagateTo(x3, y5, z3 + 1, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (z3 <= minZ) continue;
            FillNearestOperation.propagateTo(x3, y5, z3 - 1, propagateDataMap, propagateQueue, propagateData.blocks);
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        propagateDataMap.forEachEntry((x, y, z, data) -> {
            if (data.blocks != null) {
                class_2680 blockState = data.blocks.get((int)0).blockState;
                setOperation.set(x, y, z, blockState);
                previousBlocksForUndo.set(x, y, z, AIR);
                ++changeCount.value;
            }
        });
        if (changeCount.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String historyDescription = AxiomI18n.get("axiom.history_description.fill_nearest", countString);
        RegionHelper.pushBlockBufferChange(setOperation, aabb.center(), historyDescription, null);
    }

    private static void fillNearestSet(SelectionBuffer.Set set) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        Position2ObjectMap<PropagateData> propagateDataMap = new Position2ObjectMap<PropagateData>(k -> new PropagateData[4096]);
        LongArrayFIFOQueue propagateQueue = new LongArrayFIFOQueue();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        ChunkedBooleanRegion region = set.selectionRegion;
        region.forEach((x, y, z) -> {
            class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (!block.method_26215()) {
                PropagateDataBlock propagateDataBlock = new PropagateDataBlock(class_2338.method_10064((int)x, (int)y, (int)z), block);
                propagateDataMap.put(x, y, z, new PropagateData(0, null));
                if (region.contains(x + 1, y, z)) {
                    FillNearestOperation.initialPropagateTo((class_1937)world, x + 1, y, z, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
                if (region.contains(x - 1, y, z)) {
                    FillNearestOperation.initialPropagateTo((class_1937)world, x - 1, y, z, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
                if (region.contains(x, y + 1, z)) {
                    FillNearestOperation.initialPropagateTo((class_1937)world, x, y + 1, z, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
                if (region.contains(x, y - 1, z)) {
                    FillNearestOperation.initialPropagateTo((class_1937)world, x, y - 1, z, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
                if (region.contains(x, y, z + 1)) {
                    FillNearestOperation.initialPropagateTo((class_1937)world, x, y, z + 1, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
                if (region.contains(x, y, z - 1)) {
                    FillNearestOperation.initialPropagateTo((class_1937)world, x, y, z - 1, mutableBlockPos, propagateDataMap, propagateQueue, propagateDataBlock);
                }
            } else {
                class_2680 neighbor;
                if (!region.contains(x + 1, y, z) && !(neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x + 1, y, z))).method_26215()) {
                    PropagateDataBlock propagateNeighbor = new PropagateDataBlock(class_2338.method_10064((int)(x + 1), (int)y, (int)z), neighbor);
                    FillNearestOperation.initialPropagateToAssumeAir(x, y, z, propagateDataMap, propagateQueue, propagateNeighbor);
                    return;
                }
                if (!region.contains(x - 1, y, z) && !(neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x - 1, y, z))).method_26215()) {
                    PropagateDataBlock propagateNeighbor = new PropagateDataBlock(class_2338.method_10064((int)(x - 1), (int)y, (int)z), neighbor);
                    FillNearestOperation.initialPropagateToAssumeAir(x, y, z, propagateDataMap, propagateQueue, propagateNeighbor);
                    return;
                }
                if (!region.contains(x, y + 1, z) && !(neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y + 1, z))).method_26215()) {
                    PropagateDataBlock propagateNeighbor = new PropagateDataBlock(class_2338.method_10064((int)x, (int)(y + 1), (int)z), neighbor);
                    FillNearestOperation.initialPropagateToAssumeAir(x, y, z, propagateDataMap, propagateQueue, propagateNeighbor);
                    return;
                }
                if (!region.contains(x, y - 1, z) && !(neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z))).method_26215()) {
                    PropagateDataBlock propagateNeighbor = new PropagateDataBlock(class_2338.method_10064((int)x, (int)(y - 1), (int)z), neighbor);
                    FillNearestOperation.initialPropagateToAssumeAir(x, y, z, propagateDataMap, propagateQueue, propagateNeighbor);
                    return;
                }
                if (!region.contains(x, y, z + 1) && !(neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z + 1))).method_26215()) {
                    PropagateDataBlock propagateNeighbor = new PropagateDataBlock(class_2338.method_10064((int)x, (int)y, (int)(z + 1)), neighbor);
                    FillNearestOperation.initialPropagateToAssumeAir(x, y, z, propagateDataMap, propagateQueue, propagateNeighbor);
                    return;
                }
                if (!region.contains(x, y, z - 1) && !(neighbor = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z - 1))).method_26215()) {
                    PropagateDataBlock propagateNeighbor = new PropagateDataBlock(class_2338.method_10064((int)x, (int)y, (int)(z - 1)), neighbor);
                    FillNearestOperation.initialPropagateToAssumeAir(x, y, z, propagateDataMap, propagateQueue, propagateNeighbor);
                }
            }
        });
        while (!propagateQueue.isEmpty()) {
            long pos = propagateQueue.dequeueLong();
            int x2 = class_2338.method_10061((long)pos);
            int y2 = class_2338.method_10071((long)pos);
            int z2 = class_2338.method_10083((long)pos);
            PropagateData propagateData = (PropagateData)propagateDataMap.get(x2, y2, z2);
            propagateData.queued = false;
            if (region.contains(x2 + 1, y2, z2)) {
                FillNearestOperation.propagateTo(x2 + 1, y2, z2, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (region.contains(x2 - 1, y2, z2)) {
                FillNearestOperation.propagateTo(x2 - 1, y2, z2, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (region.contains(x2, y2 + 1, z2)) {
                FillNearestOperation.propagateTo(x2, y2 + 1, z2, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (region.contains(x2, y2 - 1, z2)) {
                FillNearestOperation.propagateTo(x2, y2 - 1, z2, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (region.contains(x2, y2, z2 + 1)) {
                FillNearestOperation.propagateTo(x2, y2, z2 + 1, propagateDataMap, propagateQueue, propagateData.blocks);
            }
            if (!region.contains(x2, y2, z2 - 1)) continue;
            FillNearestOperation.propagateTo(x2, y2, z2 - 1, propagateDataMap, propagateQueue, propagateData.blocks);
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        propagateDataMap.forEachEntry((x, y, z, data) -> {
            if (data.blocks != null) {
                class_2680 blockState = data.blocks.get((int)0).blockState;
                setOperation.set(x, y, z, blockState);
                previousBlocksForUndo.set(x, y, z, AIR);
                ++changeCount.value;
            }
        });
        if (changeCount.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String historyDescription = AxiomI18n.get("axiom.history_description.fill_nearest", countString);
        RegionHelper.pushBlockBufferChange(setOperation, set.center(), historyDescription, null);
    }

    private static void initialPropagateTo(class_1937 level, int x, int y, int z, class_2338.class_2339 mutableBlockPos, Position2ObjectMap<PropagateData> propagateDataMap, LongArrayFIFOQueue propagateQueue, PropagateDataBlock propagateDataBlock) {
        class_2680 state = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (!state.method_26215()) {
            return;
        }
        PropagateData propagateData = propagateDataMap.get(x, y, z);
        if (propagateData == null) {
            ArrayList<PropagateDataBlock> list = new ArrayList<PropagateDataBlock>();
            list.add(propagateDataBlock);
            propagateData = new PropagateData(1, list);
            propagateData.queued = true;
            propagateDataMap.put(x, y, z, propagateData);
            propagateQueue.enqueue(class_2338.method_10064((int)x, (int)y, (int)z));
        } else if (propagateData.minDistanceSq != 0) {
            propagateData.blocks.add(propagateDataBlock);
        }
    }

    private static void initialPropagateToAssumeAir(int x, int y, int z, Position2ObjectMap<PropagateData> propagateDataMap, LongArrayFIFOQueue propagateQueue, PropagateDataBlock propagateDataBlock) {
        PropagateData propagateData = propagateDataMap.get(x, y, z);
        if (propagateData == null) {
            ArrayList<PropagateDataBlock> list = new ArrayList<PropagateDataBlock>();
            list.add(propagateDataBlock);
            propagateData = new PropagateData(1, list);
            propagateData.queued = true;
            propagateDataMap.put(x, y, z, propagateData);
            propagateQueue.enqueue(class_2338.method_10064((int)x, (int)y, (int)z));
        } else if (propagateData.minDistanceSq != 0) {
            propagateData.blocks.add(propagateDataBlock);
        }
    }

    private static void propagateTo(int x, int y, int z, Position2ObjectMap<PropagateData> propagateDataMap, LongArrayFIFOQueue propagateQueue, List<PropagateDataBlock> blocks) {
        PropagateData propagateData = propagateDataMap.get(x, y, z);
        if (propagateData != null && propagateData.minDistanceSq == 0) {
            return;
        }
        int minDistanceSq = Integer.MAX_VALUE;
        PropagateDataBlock minPropagate = null;
        for (PropagateDataBlock block : blocks) {
            int dz;
            int dy;
            int dx = class_2338.method_10061((long)block.origin) - x;
            int distanceSq = dx * dx + (dy = class_2338.method_10071((long)block.origin) - y) * dy + (dz = class_2338.method_10083((long)block.origin) - z) * dz;
            if (distanceSq >= minDistanceSq) continue;
            minDistanceSq = distanceSq;
            minPropagate = block;
        }
        if (propagateData == null) {
            ArrayList<PropagateDataBlock> list = new ArrayList<PropagateDataBlock>();
            list.add(minPropagate);
            propagateData = new PropagateData(minDistanceSq, list);
            propagateData.queued = true;
            propagateDataMap.put(x, y, z, propagateData);
            propagateQueue.enqueue(class_2338.method_10064((int)x, (int)y, (int)z));
        } else if (minDistanceSq < propagateData.minDistanceSq) {
            propagateData.minDistanceSq = minDistanceSq;
            propagateData.blocks.clear();
            propagateData.blocks.add(minPropagate);
            if (!propagateData.queued) {
                propagateQueue.enqueue(class_2338.method_10064((int)x, (int)y, (int)z));
                propagateData.queued = true;
            }
        } else if (minDistanceSq == propagateData.minDistanceSq) {
            propagateData.blocks.add(minPropagate);
        }
    }

    private record PropagateDataBlock(long origin, class_2680 blockState) {
    }

    private static final class PropagateData {
        private int minDistanceSq;
        private boolean queued = false;
        private final List<PropagateDataBlock> blocks;

        PropagateData(int minDistanceSq, List<PropagateDataBlock> blocks) {
            this.minDistanceSq = minDistanceSq;
            this.blocks = blocks;
        }
    }
}

