/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.funcinterfaces.IntIntObjectConsumer;
import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.LongFunction;
import net.minecraft.class_1923;

public class Position2dToObjectMap<T> {
    private final LongFunction<T[]> defaultFunction;
    private final Long2ObjectMap<T[]> map;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private T[] lastChunk = null;

    public Position2dToObjectMap(LongFunction<T[]> defaultChunkSupplier) {
        this((Long2ObjectMap<T[]>)new Long2ObjectOpenHashMap(), defaultChunkSupplier);
    }

    public Position2dToObjectMap(Long2ObjectMap<T[]> map, LongFunction<T[]> defaultChunkSupplier) {
        this.map = map;
        this.defaultFunction = defaultChunkSupplier;
    }

    public void clear() {
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public T get(int x, int z) {
        int xC = x >> 4;
        int zC = z >> 4;
        T[] array = this.getChunk(xC, zC);
        if (array == null) {
            return null;
        }
        return array[(x & 0xF) + (z & 0xF) * 16];
    }

    public void put(int x, int z, T v) {
        int xC = x >> 4;
        int zC = z >> 4;
        T[] array = this.getOrCreateChunk(xC, zC);
        array[(x & 0xF) + (z & 0xF) * 16] = v;
    }

    public void forEachEntry(IntIntObjectConsumer<T> consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_1923.method_8325((long)entry.getLongKey()) * 16;
            int cz = class_1923.method_8332((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Object v = ((Object[])entry.getValue())[index++];
                    if (v == null) continue;
                    consumer.accept(cx + x, cz + z, v);
                }
            }
        }
    }

    public class_1923 getLastChunk() {
        if (this.lastChunk != null && this.lastChunkPos != PositionUtils.MIN_POSITION_LONG) {
            return new class_1923(this.lastChunkPos);
        }
        if (!this.map.isEmpty()) {
            return new class_1923(this.map.keySet().iterator().nextLong());
        }
        return new class_1923(0, 0);
    }

    public T[] getChunk(int xC, int zC) {
        return this.getChunk(class_1923.method_8331((int)xC, (int)zC));
    }

    public T[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            Object[] chunk = (Object[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public T[] getOrCreateChunk(int xC, int zC) {
        return this.getOrCreateChunk(class_1923.method_8331((int)xC, (int)zC));
    }

    public T[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            Object[] chunk = (Object[])this.map.computeIfAbsent(pos, this.defaultFunction);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }
}

