/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.buildertools.BuilderToolSelectionState;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import java.util.EnumSet;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class SmearBuilderTool
implements BuilderTool {
    private final BuilderToolSelectionState selectionState = new BuilderToolSelectionState();
    private SelectionBuffer selectionBuffer = null;
    private class_2338.class_2339 smearDirections = null;
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();

    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.smearDirections != null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.cancel"), class_310.method_1551().field_1690.field_1886, 0);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.confirm"), class_310.method_1551().field_1690.field_1904, 1);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.smear.smear_to"), class_310.method_1551().field_1690.field_1871, 2);
            return;
        }
        this.selectionState.renderScreen(guiGraphics, screenWidth, screenHeight);
    }

    @Override
    public void handleInput(boolean nudgeForwards, boolean nudgeBackwards, boolean delete) {
        if (nudgeForwards) {
            this.nudge(1);
        }
        if (nudgeBackwards) {
            this.nudge(-1);
        }
        if (delete) {
            if (this.smearDirections == null) {
                this.selectionState.createSelectionBuffer().callDelete(HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME);
            }
            this.reset(false);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.smearDirections != null) {
            this.blockRegion.render(camera, class_243.field_1353, matrices, projection, 0.8f, 0.0f);
        }
        this.selectionState.renderWorld(camera, time, matrices, projection);
    }

    @Override
    public boolean setPos1(class_2338 position) {
        if (this.smearDirections == null) {
            this.selectionState.setPos1(position);
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public boolean setPos2(class_2338 position) {
        if (this.smearDirections == null) {
            this.selectionState.setPos2(position);
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public void leftClick(class_239 hitResult) {
        if (this.smearDirections != null) {
            this.reset(false);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.selectionState.leftClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (this.smearDirections != null) {
            this.reset(true);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.selectionState.rightClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (this.smearDirections != null) {
                class_2338 min2 = this.selectionBuffer.min();
                class_2338 max2 = this.selectionBuffer.max();
                if (min2 == null || max2 == null) {
                    return;
                }
                class_2338 target = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                if (target.method_10263() < min2.method_10263()) {
                    this.smearDirections.method_33097(target.method_10263() - min2.method_10263());
                } else if (target.method_10263() > max2.method_10263()) {
                    this.smearDirections.method_33097(target.method_10263() - max2.method_10263());
                } else {
                    this.smearDirections.method_33097(0);
                }
                if (target.method_10264() < min2.method_10264()) {
                    this.smearDirections.method_33098(target.method_10264() - min2.method_10264());
                } else if (target.method_10264() > max2.method_10264()) {
                    this.smearDirections.method_33098(target.method_10264() - max2.method_10264());
                } else {
                    this.smearDirections.method_33098(0);
                }
                if (target.method_10260() < min2.method_10260()) {
                    this.smearDirections.method_33099(target.method_10260() - min2.method_10260());
                } else if (target.method_10260() > max2.method_10260()) {
                    this.smearDirections.method_33099(target.method_10260() - max2.method_10260());
                } else {
                    this.smearDirections.method_33099(0);
                }
                this.updateSmear();
            } else {
                this.selectionState.middleClick(blockHitResult);
            }
            this.showTextInActionBar();
        }
    }

    private void apply() {
        if (this.smearDirections != null && (this.smearDirections.method_10263() != 0 || this.smearDirections.method_10264() != 0 || this.smearDirections.method_10260() != 0)) {
            String description = AxiomI18n.get("axiom.history_description.smeared", NumberFormat.getInstance().format(this.blockRegion.count()));
            int flags = HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME;
            if (BuilderToolManager.keepExisting) {
                flags |= HistoryEntry.MODIFIER_KEEP_EXISTING;
            }
            RegionHelper.pushBlockRegionChangeWithNBT(this.blockRegion, description, flags, null);
        }
    }

    @Override
    public boolean scroll(int scroll) {
        if (!this.selectionState.hasSelection()) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_2350 dir = BuilderTool.calculateDirection();
        if (this.smearDirections == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                this.nudge(scroll);
                return true;
            }
            this.smearDirections = new class_2338.class_2339();
        }
        this.smearDirections.method_10104(dir, scroll);
        this.showTextInActionBar();
        this.updateSmear();
        return true;
    }

    private void updateSmear() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        this.blockRegion.clear();
        if (this.selectionBuffer != null) {
            this.selectionBuffer.close();
        }
        this.selectionBuffer = this.selectionState.createSelectionBuffer();
        if (this.selectionBuffer.isEmpty()) {
            return;
        }
        int smearX = this.smearDirections.method_10263();
        int smearY = this.smearDirections.method_10264();
        int smearZ = this.smearDirections.method_10260();
        int maxSmear = Math.max(Math.abs(smearX), Math.max(Math.abs(smearY), Math.abs(smearZ)));
        if (maxSmear == 0) {
            return;
        }
        record BlockStateWithDistance(class_2680 blockState, int distanceSq) {
        }
        Position2ObjectMap<BlockStateWithDistance> blockMap = new Position2ObjectMap<BlockStateWithDistance>(k -> new BlockStateWithDistance[4096]);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        this.selectionBuffer.forEach((arg_0, arg_1, arg_2) -> this.lambda$updateSmear$1((class_1937)level, mutableBlockPos, maxSmear, smearX, smearY, smearZ, blockMap, arg_0, arg_1, arg_2));
        blockMap.forEachEntry((x, y, z, bswd) -> this.blockRegion.addBlock(x, y, z, bswd.blockState));
    }

    private void nudge(int amount) {
        if (this.smearDirections != null) {
            return;
        }
        this.selectionState.nudge(amount);
        this.showTextInActionBar();
    }

    private void showTextInActionBar() {
        if (this.smearDirections != null) {
            ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Smear Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(this.smearDirections.method_10263() + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(this.smearDirections.method_10264() + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + this.smearDirections.method_10260())).method_27692(class_124.field_1075)));
        } else {
            this.selectionState.showTextInActionBar();
        }
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        if (this.smearDirections != null) {
            return false;
        }
        return !this.selectionState.selectionContains(blockPos);
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.smear");
    }

    @Override
    public boolean canBeReset() {
        return this.selectionState.hasSelection() || this.smearDirections != null;
    }

    @Override
    public void reset(boolean apply) {
        if (apply && this.selectionState.hasSelection() && this.smearDirections != null) {
            this.apply();
        }
        this.selectionState.resetSelection();
        this.blockRegion.clear();
        this.smearDirections = null;
        if (this.selectionBuffer != null) {
            this.selectionBuffer.close();
            this.selectionBuffer = null;
        }
    }

    @Override
    public BuilderToolSelectionState.Restore getSelectionRestore() {
        return this.selectionState.getSelectionRestore();
    }

    @Override
    public void applySelectionRestore(BuilderToolSelectionState.Restore restore) {
        this.selectionState.restoreFrom(restore);
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.BUILDERTOOL_SMEAR, AxiomPermission.BUILD_SECTION);
    }

    private /* synthetic */ void lambda$updateSmear$1(class_1937 level, class_2338.class_2339 mutableBlockPos, int maxSmear, int smearX, int smearY, int smearZ, Position2ObjectMap blockMap, int x, int y, int z) {
        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (BuilderToolManager.copyAir || !blockState.method_26215()) {
            for (int driver = 1; driver <= maxSmear; ++driver) {
                int nx = x + Math.round((float)(driver * smearX) / (float)maxSmear);
                int ny = y + Math.round((float)(driver * smearY) / (float)maxSmear);
                int nz = z + Math.round((float)(driver * smearZ) / (float)maxSmear);
                if (BuilderToolManager.copyAir) {
                    if (!blockState.method_26215()) {
                        if (this.selectionBuffer.contains(nx, ny, nz)) continue;
                        if (!level.method_8320((class_2338)mutableBlockPos.method_10103(nx, ny, nz)).method_45474()) {
                            break;
                        }
                    }
                } else if (!level.method_8320((class_2338)mutableBlockPos.method_10103(nx, ny, nz)).method_45474()) {
                    if (!this.selectionBuffer.contains(nx, ny, nz)) break;
                    continue;
                }
                BlockStateWithDistance bswd = (BlockStateWithDistance)blockMap.get(nx, ny, nz);
                int distanceSq = (nx - x) * (nx - x) + (ny - y) * (ny - y) + (nz - z) * (nz - z);
                if (bswd != null && distanceSq >= bswd.distanceSq) continue;
                blockMap.put(nx, ny, nz, new BlockStateWithDistance(blockState, distanceSq));
            }
        }
    }
}

