/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_243;

public class SpaceLookup<T> {
    private final Map<class_243, T> items = new LinkedHashMap<class_243, T>();

    public void clear() {
        this.items.clear();
    }

    public void edit(class_243 position, UnaryOperator<T> op) {
        T existingItem = this.items.get(position);
        Object newItem = op.apply(existingItem);
        if (newItem != existingItem) {
            this.items.put(position, newItem);
        }
    }

    public T nearest(class_243 position) {
        T nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (Map.Entry<class_243, T> entry : this.items.entrySet()) {
            double distance = entry.getKey().method_1025(position);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = entry.getValue();
        }
        return nearest;
    }

    public List<T> nearestN(class_243 position, int n) {
        if ((n = Math.min(n, this.items.size())) < 1) {
            return List.of();
        }
        if (n == 1) {
            return List.of(this.nearest(position));
        }
        DoubleArrayList nearestDistances = new DoubleArrayList(n + 1);
        ArrayList<T> nearest = new ArrayList<T>(n + 1);
        double lowestDistance = Double.POSITIVE_INFINITY;
        double highestDistance = Double.POSITIVE_INFINITY;
        for (Map.Entry<class_243, T> entry : this.items.entrySet()) {
            double distance = entry.getKey().method_1025(position);
            if (distance < lowestDistance) {
                nearestDistances.add(0, distance);
                nearest.add(0, entry.getValue());
                if (nearest.size() > n) {
                    nearest.remove(n);
                    nearestDistances.removeDouble(n);
                }
                lowestDistance = distance;
                highestDistance = nearestDistances.getDouble(nearestDistances.size() - 1);
                continue;
            }
            if (distance > highestDistance) {
                if (nearest.size() >= n) continue;
                nearest.add(entry.getValue());
                nearestDistances.add(distance);
                highestDistance = distance;
                continue;
            }
            for (int i = 0; i < nearestDistances.size(); ++i) {
                double otherDistance = nearestDistances.getDouble(i);
                if (!(distance < otherDistance)) continue;
                nearestDistances.add(i, distance);
                nearest.add(i, entry.getValue());
                break;
            }
            if (nearest.size() > n) {
                nearest.remove(n);
                nearestDistances.removeDouble(n);
            }
            highestDistance = nearestDistances.getDouble(nearestDistances.size() - 1);
        }
        return nearest;
    }
}

