/*
 * Decompiled with CFR 0.152.
 */
package elocindev.animation_overhaul.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import elocindev.animation_overhaul.AnimationOverhaul;
import elocindev.animation_overhaul.api.AnimationHolder;
import elocindev.animation_overhaul.api.ILeanablePlayer;
import elocindev.animation_overhaul.compat.CompatibilityLoader;
import elocindev.animation_overhaul.config.AnimationsConfig;
import elocindev.animation_overhaul.registry.AOAnimationInstance;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1743;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements ILeanablePlayer {
    @Unique
    private final ModifierLayer<IAnimation> CONTAINER = new ModifierLayer();
    public AnimationHolder anim_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sneak_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sneak_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_run = AnimationHolder.EMPTY;
    public AnimationHolder anim_turn_right = AnimationHolder.EMPTY;
    public AnimationHolder anim_turn_left = AnimationHolder.EMPTY;
    public AnimationHolder anim_falling = AnimationHolder.EMPTY;
    public AnimationHolder anim_slow_falling = AnimationHolder.EMPTY;
    public AnimationHolder anim_landing = AnimationHolder.EMPTY;
    public AnimationHolder anim_swimming = AnimationHolder.EMPTY;
    public AnimationHolder anim_swim_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_crawl_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_crawling = AnimationHolder.EMPTY;
    public AnimationHolder anim_eating = AnimationHolder.EMPTY;
    public AnimationHolder anim_drinking = AnimationHolder.EMPTY;
    public AnimationHolder anim_climbing = AnimationHolder.EMPTY;
    public AnimationHolder anim_climbing_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_sprint_stop = AnimationHolder.EMPTY;
    public AnimationHolder anim_fence_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_fence_walk = AnimationHolder.EMPTY;
    public AnimationHolder anim_edge_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_elytra_fly = AnimationHolder.EMPTY;
    public AnimationHolder anim_flint_and_steel = AnimationHolder.EMPTY;
    public AnimationHolder anim_flint_and_steel_sneak = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_idle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_left_paddle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_right_paddle = AnimationHolder.EMPTY;
    public AnimationHolder anim_boat_forward = AnimationHolder.EMPTY;
    public AnimationHolder anim_rolling = AnimationHolder.EMPTY;
    public AnimationHolder[] anim_jump = new AnimationHolder[2];
    public AnimationHolder[] anim_fall = new AnimationHolder[2];
    public AnimationHolder[] anim_punch = new AnimationHolder[2];
    public AnimationHolder[] anim_punch_sneaking = new AnimationHolder[2];
    public AnimationHolder[] anim_sword_swing = new AnimationHolder[2];
    public AnimationHolder[] anim_sword_swing_sneak = new AnimationHolder[2];
    public int punch_index = 0;
    public int jump_index = 0;
    public float leanAmount = 0.0f;
    public float leanMultiplier = 1.0f;
    public float realLeanMultiplier = 1.0f;
    public float squash = 0.0f;
    public float realSquash = 0.0f;
    public float momentum = 0.0f;
    public AnimationsConfig ANIMS = AnimationOverhaul.ANIM_CONFIG;
    public float turnDelta = 0.0f;
    public class_243 lastPos = new class_243(0.0, 0.0, 0.0);
    public boolean lastOnGround = false;
    public boolean hasSlowFall = false;
    private int tickCounter = 0;
    KeyframeAnimation currentAnimation = null;
    private boolean modified = false;
    private boolean armAnimationsEnabled = true;

    public AbstractClientPlayerEntityMixin(class_1937 level, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(level, pos, yaw, gameProfile);
    }

    private AnimationHolder validateHolder(AnimationHolder holder) {
        if (holder == null) {
            throw new RuntimeException("Missing animation from config! Your config is corrupt, you might have deleted some animations.");
        }
        return holder;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void animation_overhaul$init(class_638 level, GameProfile profile, CallbackInfo info) {
        PlayerAnimationAccess.getPlayerAnimLayer((class_742)((class_742)this)).addAnimLayer(1, this.CONTAINER);
        AOAnimationInstance.States cfg = this.ANIMS.enabled_animations;
        this.anim_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "idle"), cfg.idle.enabled));
        this.anim_fall[0] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "fall_first"), cfg.fall.enabled));
        this.anim_fall[1] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "fall_second"), cfg.fall.enabled));
        this.anim_jump[0] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "jump_first"), cfg.jump.enabled));
        this.anim_jump[1] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "jump_second"), cfg.jump.enabled));
        this.anim_sneak_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sneak_idle"), cfg.sneak_idle.enabled));
        this.anim_sneak_walk = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sneak_walk"), cfg.sneak_walk.enabled));
        this.anim_walk = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "walking"), cfg.walk.enabled));
        this.anim_run = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "running"), cfg.run.enabled));
        this.anim_turn_right = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "turn_right"), cfg.turn_right.enabled));
        this.anim_turn_left = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "turn_left"), cfg.turn_left.enabled));
        this.anim_punch[0] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "punch_right"), cfg.punch.enabled));
        this.anim_punch[1] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "punch_left"), cfg.punch.enabled));
        this.anim_punch_sneaking[0] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "punch_right_sneak"), cfg.punch_sneaking.enabled));
        this.anim_punch_sneaking[1] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "punch_left_sneak"), cfg.punch_sneaking.enabled));
        this.anim_sword_swing[0] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sword_swing_first"), cfg.sword_swing.enabled));
        this.anim_sword_swing[1] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sword_swing_second"), cfg.sword_swing.enabled));
        this.anim_sword_swing_sneak[0] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sword_swing_sneak_first"), cfg.sword_swing_sneak.enabled));
        this.anim_sword_swing_sneak[1] = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sword_swing_sneak_second"), cfg.sword_swing_sneak.enabled));
        this.anim_falling = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "falling"), cfg.falling.enabled));
        this.anim_slow_falling = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "slow_falling"), cfg.slow_falling.enabled));
        this.anim_landing = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "landing"), cfg.landing.enabled));
        this.anim_swimming = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "swimming"), cfg.swimming.enabled));
        this.anim_swim_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "swim_idle"), cfg.swim_idle.enabled));
        this.anim_crawl_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "crawl_idle"), cfg.crawl_idle.enabled));
        this.anim_crawling = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "crawling"), cfg.crawling.enabled));
        this.anim_eating = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "eating"), cfg.eating.enabled));
        this.anim_drinking = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "drinking"), cfg.drinking.enabled));
        this.anim_climbing = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "climbing"), cfg.climbing.enabled));
        this.anim_climbing_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "climbing_idle"), cfg.climbing_idle.enabled));
        this.anim_sprint_stop = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "sprint_stop"), cfg.sprint_stop.enabled));
        this.anim_fence_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "fence_idle"), cfg.fence_idle.enabled));
        this.anim_fence_walk = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "fence_walk"), cfg.fence_walk.enabled));
        this.anim_edge_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "edge_idle"), cfg.edge_idle.enabled));
        this.anim_elytra_fly = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "elytra_fly"), cfg.elytra_fly.enabled));
        this.anim_flint_and_steel = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "flint_and_steel"), cfg.flint_and_steel.enabled));
        this.anim_flint_and_steel_sneak = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "flint_and_steel_sneak"), cfg.flint_and_steel_sneak.enabled));
        this.anim_boat_idle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "boat_idle"), cfg.boat_idle.enabled));
        this.anim_boat_forward = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "boat_forward"), cfg.boat_forward.enabled));
        this.anim_boat_right_paddle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "boat_right_paddle"), cfg.boat_right_paddle.enabled));
        this.anim_boat_left_paddle = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "boat_left_paddle"), cfg.boat_left_paddle.enabled));
        this.anim_rolling = this.validateHolder(new AnimationHolder(new class_2960(AnimationOverhaul.MODID, "rolling"), cfg.rolling.enabled));
    }

    public void method_5773() {
        boolean onGroundInWater;
        boolean isWalkingForwards;
        class_2248 standingBlock;
        super.method_5773();
        if (this.method_5765() && !(this.method_5854() instanceof class_1690)) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter == 20) {
            this.hasSlowFall = this.method_6059(class_1294.field_5906);
            this.tickCounter = 0;
        }
        class_1937 level = this.method_37908();
        boolean onGround = this.method_24828();
        float delta = 0.05f;
        class_243 pos = this.method_19538();
        if (!this.method_24828() && this.lastOnGround && this.method_18798().field_1351 > 0.0) {
            this.playJumpAnimation();
        }
        boolean onFence = ((standingBlock = level.method_8320(this.method_24515().method_10074()).method_26204()) instanceof class_2354 || standingBlock instanceof class_2544 || standingBlock instanceof class_2389) && this.method_24828();
        boolean onEdge = level.method_8320(this.method_24515().method_10074()).method_26215() && this.method_24828();
        this.leanAmount = this.turnDelta != 0.0f ? MathHelper.lerp((float)(delta * 4.0f), (float)this.leanAmount, (float)(this.field_6283 - this.field_6220)) : MathHelper.lerp((float)(delta * 4.0f), (float)this.leanAmount, (float)0.0f);
        this.leanMultiplier = MathHelper.lerp((float)(delta * 8.0f), (float)this.leanMultiplier, (float)this.realLeanMultiplier);
        this.squash = MathHelper.lerp((float)(delta * 8.0f), (float)this.squash, (float)this.realSquash);
        this.realSquash = MathHelper.lerp((float)(delta * 8.0f), (float)this.realSquash, (float)0.0f);
        Vec3f movementVector = new Vec3f((float)(pos.field_1352 - this.lastPos.field_1352), 0.0f, (float)(pos.field_1350 - this.lastPos.field_1350));
        Vec3f lookVector = new Vec3f((float)Math.cos(Math.toRadians(this.field_6283 + 90.0f)), 0.0f, (float)Math.sin(Math.toRadians(this.field_6283 + 90.0f)));
        float movementLength = (float)Math.sqrt(((Float)movementVector.getX()).floatValue() * ((Float)movementVector.getX()).floatValue() + ((Float)movementVector.getY()).floatValue() * ((Float)movementVector.getY()).floatValue() + ((Float)movementVector.getZ()).floatValue() * ((Float)movementVector.getZ()).floatValue());
        boolean isWalking = movementLength > 0.0f;
        float dotProduct = ((Float)movementVector.getX()).floatValue() * ((Float)lookVector.getX()).floatValue() + ((Float)movementVector.getY()).floatValue() * ((Float)lookVector.getY()).floatValue() + ((Float)movementVector.getZ()).floatValue() * ((Float)lookVector.getZ()).floatValue();
        boolean bl = isWalkingForwards = isWalking && dotProduct > 0.0f;
        float walk_sign = isWalking ? (isWalkingForwards ? 1.0f : -1.0f) : 0.0f;
        float sprint_multiplier = this.method_5624() && isWalkingForwards ? 2 : 1;
        this.momentum = MathHelper.lerp((float)(delta * 2.0f * sprint_multiplier), (float)this.momentum, (float)(walk_sign * sprint_multiplier));
        this.realLeanMultiplier = this.realLeanMultiplier < 1.0f ? (this.realLeanMultiplier += 0.1f) : 1.0f;
        AnimationHolder animationToPlay = AnimationHolder.EMPTY;
        boolean bl2 = onGroundInWater = this.method_5869() && this.method_25936().method_26220((class_1922)this.method_37908(), this.method_24515()).method_1110();
        if (!this.field_6252 || this.field_6279 >= this.getCurrentSwingDuration() / 2 || this.field_6279 < 0) {
            if (this.method_5765() && this.method_5854() instanceof class_1690) {
                animationToPlay = this.anim_boat_idle;
                boolean left_paddle = ((class_1690)this.method_5854()).method_7556(0);
                boolean right_paddle = ((class_1690)this.method_5854()).method_7556(1);
                if (left_paddle && right_paddle) {
                    animationToPlay = this.anim_boat_forward;
                } else if (left_paddle) {
                    animationToPlay = this.anim_boat_left_paddle;
                } else if (right_paddle) {
                    animationToPlay = this.anim_boat_right_paddle;
                }
            } else if (level.method_8320(this.method_24515()).method_26204() instanceof class_2399 && !this.method_24828() && !this.field_6282) {
                animationToPlay = this.anim_climbing_idle;
                if (this.method_18798().field_1351 > 0.0) {
                    animationToPlay = this.anim_climbing;
                }
            } else if (this.method_6115()) {
                if (this.method_6047().method_7909().method_19263()) {
                    animationToPlay = this.anim_eating;
                }
                if (this.method_6030().method_7976() == class_1839.field_8946) {
                    animationToPlay = this.anim_drinking;
                }
            } else if (this.method_6128()) {
                animationToPlay = this.anim_elytra_fly;
            } else if (this.method_24828() || onGroundInWater) {
                animationToPlay = this.anim_idle;
                if (onFence) {
                    animationToPlay = this.anim_fence_idle;
                } else if (onEdge) {
                    animationToPlay = this.anim_edge_idle;
                }
                if (this.turnDelta != 0.0f && !onEdge) {
                    animationToPlay = this.anim_turn_right;
                    if (this.turnDelta < 0.0f) {
                        animationToPlay = this.anim_turn_left;
                    }
                }
                if ((this.method_5816() || this.method_5771()) && !onGroundInWater) {
                    if (this.method_5681() || this.method_5624()) {
                        animationToPlay = this.anim_swimming;
                    }
                } else if (this.method_20448()) {
                    animationToPlay = isWalking ? this.anim_crawling : this.anim_crawl_idle;
                } else if (this.method_5715()) {
                    animationToPlay = this.anim_sneak_idle;
                    if (isWalking || this.turnDelta != 0.0f) {
                        animationToPlay = this.anim_sneak_walk;
                    }
                } else if (isWalking) {
                    if (this.momentum > 1.0f && !isWalkingForwards) {
                        animationToPlay = this.anim_sprint_stop;
                    } else if (this.method_5624() && !this.method_6115()) {
                        animationToPlay = this.anim_run;
                    } else {
                        animationToPlay = this.anim_walk;
                        if (onFence) {
                            animationToPlay = this.anim_fence_walk;
                        }
                    }
                }
            } else {
                if (this.field_6017 > 1.0f) {
                    animationToPlay = this.field_6017 > 3.0f ? this.anim_falling : this.anim_fall[this.jump_index];
                }
                if (!this.method_24828() && this.method_18798().field_1351 < 0.0 && this.hasSlowFall) {
                    animationToPlay = this.anim_slow_falling;
                }
            }
            if (this.method_5816() || this.method_5771()) {
                animationToPlay = this.method_5681() || this.method_5624() ? this.anim_swimming : this.anim_swim_idle;
            }
        }
        if (animationToPlay != null && animationToPlay.isEnabled()) {
            this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade());
        }
        if (this.method_6115()) {
            if (this.method_6030() != null) {
                class_1839 action = this.method_6030().method_7976();
                if (action == class_1839.field_8953 || action == class_1839.field_8947 || action == class_1839.field_27079 || action == class_1839.field_8951 || action == class_1839.field_39058 || action == class_1839.field_8949) {
                    this.disableArmAnimations();
                } else if (this.method_6030().method_7909() instanceof class_1786) {
                    animationToPlay = this.anim_flint_and_steel;
                    if (this.method_5715()) {
                        animationToPlay = this.anim_flint_and_steel_sneak;
                    }
                    if (animationToPlay != null && animationToPlay.isEnabled()) {
                        this.playAnimation(animationToPlay.getAnimation(), animationToPlay.getSpeed(), animationToPlay.getFade());
                    }
                }
            }
        } else {
            this.enableArmAnimations();
        }
        this.lastPos = new class_243(pos.field_1352, pos.field_1351, pos.field_1350);
        this.lastOnGround = onGround;
    }

    public void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        if (this.field_6017 > 0.0f) {
            if (onGround) {
                if (this.field_6017 >= 3.0f) {
                    this.playAnimation(this.anim_landing.getAnimation(), 1.0f, 0);
                }
                this.realSquash = -this.field_6017 / 10.0f;
            } else {
                this.realSquash = Math.min(this.field_6017 / 20.0f, 0.25f);
            }
        }
        super.method_5623(heightDifference, onGround, state, landedPosition);
    }

    public void playAnimation(KeyframeAnimation anim) {
        this.playAnimation(anim, 1.0f, 10);
    }

    public void playAnimation(KeyframeAnimation anim, float speed, int fade) {
        this.playAnimation(this.CONTAINER, anim, speed, fade);
    }

    public void playAnimation(ModifierLayer<IAnimation> container, KeyframeAnimation anim, float speed, int fade) {
        if (this.currentAnimation == anim || anim == null) {
            return;
        }
        this.currentAnimation = anim;
        KeyframeAnimation.AnimationBuilder builder = anim.mutableCopy();
        builder.leftArm.setEnabled(this.armAnimationsEnabled);
        builder.rightArm.setEnabled(this.armAnimationsEnabled);
        anim = builder.build();
        if (this.modified) {
            container.removeModifier(0);
        }
        this.modified = true;
        container.addModifierBefore((AbstractModifier)new SpeedModifier(speed));
        container.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fade, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(anim));
        container.setupAnim(0.05f);
    }

    public void disableArmAnimations() {
        if (this.currentAnimation != null && this.armAnimationsEnabled) {
            this.armAnimationsEnabled = false;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(false);
            builder.rightArm.setEnabled(false);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this.method_6029()));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
            animationContainer.setupAnim(0.05f);
            animationContainer.tick();
        }
    }

    public void enableArmAnimations() {
        if (this.currentAnimation != null && !this.armAnimationsEnabled) {
            this.armAnimationsEnabled = true;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(true);
            builder.rightArm.setEnabled(true);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this.method_6029()));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
        }
    }

    public void playJumpAnimation() {
        this.realLeanMultiplier = 0.0f;
        this.realSquash = -0.1f;
        ++this.jump_index;
        this.jump_index %= 2;
        AnimationHolder anim = this.anim_jump[this.jump_index];
        if (anim != null && anim.isEnabled()) {
            this.playAnimation(this.CONTAINER, anim.getAnimation(), anim.getSpeed(), anim.getFade());
        }
    }

    private int getCurrentSwingDuration() {
        if (class_1292.method_5576((class_1309)this)) {
            return 6 - (1 + class_1292.method_5575((class_1309)this));
        }
        return this.method_6059(class_1294.field_5901) ? 6 + (1 + this.method_6112(class_1294.field_5901).method_5578()) * 2 : 6;
    }

    public void method_6104(class_1268 hand) {
        super.method_6104(hand);
        if (this.method_6030().method_7909() instanceof class_1786 && this.method_6115()) {
            return;
        }
        if (!this.field_6252 || this.field_6279 >= this.getCurrentSwingDuration() / 2 || this.field_6279 < 0) {
            ++this.punch_index;
            this.punch_index %= 2;
            class_1799 stack = this.method_6047();
            boolean sword_animations = false;
            if (CompatibilityLoader.BETTER_COMBAT) {
                sword_animations = false;
            }
            if (stack != null) {
                if (stack.method_7909() instanceof class_1829) {
                    sword_animations = true;
                } else if (stack.method_7909() instanceof class_1810 || stack.method_7909() instanceof class_1743 || stack.method_7909() instanceof class_1794 || stack.method_7909() instanceof class_1821 || stack.method_7909() instanceof class_1787 && this.method_6115()) {
                    sword_animations = true;
                    if (!AnimationOverhaul.ANIM_CONFIG.hands_behavior.mining) {
                        this.disableArmAnimations();
                        return;
                    }
                }
            } else if (!AnimationOverhaul.ANIM_CONFIG.hands_behavior.punch) {
                this.disableArmAnimations();
                return;
            }
            AnimationHolder hand_anim = null;
            hand_anim = this.method_5715() ? (sword_animations ? this.anim_sword_swing_sneak[this.punch_index] : this.anim_punch_sneaking[this.punch_index]) : (sword_animations ? this.anim_sword_swing[this.punch_index] : this.anim_punch[this.punch_index]);
            if (!hand_anim.isEnabled()) {
                this.disableArmAnimations();
            }
            if (hand_anim != null) {
                this.playAnimation(hand_anim.getAnimation(), 1.0f, 0);
            }
        }
    }

    @Override
    public float getLeanAmount() {
        return this.leanAmount * 0.01f;
    }

    @Override
    public float getLeanMultiplier() {
        return this.leanMultiplier;
    }

    @Override
    public float getSquash() {
        return this.squash;
    }
}

